/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.shell.equinox;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.knowhowlab.osgi.shell.equinox.CommandInterpreterWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEquinoxCommandProvider
implements CommandProvider {
    private static final Logger LOG = Logger.getLogger(AbstractEquinoxCommandProvider.class.getName());
    private String groupName;
    private Object service;
    private SortedSet<String> commandHelps = new TreeSet<String>();

    public AbstractEquinoxCommandProvider(Object service, String groupName, Set<String> commandHelps) {
        this.groupName = groupName;
        this.service = service;
        this.commandHelps.addAll(commandHelps);
    }

    public String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("---").append(this.groupName).append("---\n");
        for (String command : this.commandHelps) {
            builder.append("\t").append(command).append("\n");
        }
        return builder.toString();
    }

    protected String[] fetchCommandParams(CommandInterpreter interpreter) {
        String param;
        ArrayList<String> result = new ArrayList<String>();
        while ((param = interpreter.nextArgument()) != null) {
            result.add(param);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void runCommand(String commandName, CommandInterpreter interpreter) {
        PrintWriter out = new PrintWriter(new CommandInterpreterWriter(interpreter));
        Object[] args = this.fetchCommandParams(interpreter);
        try {
            Method method = this.service.getClass().getMethod(commandName, PrintWriter.class, String[].class);
            method.invoke(this.service, out, args);
        }
        catch (NoSuchMethodException e) {
            out.println("No such command: " + commandName);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to execute command: " + commandName + " with args: " + Arrays.toString(args), e);
            e.printStackTrace(out);
        }
    }
}

