/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.shell.equinox;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.knowhowlab.osgi.shell.equinox.AbstractEquinoxCommandProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxCommandProviderGenerator {
    private static final Logger LOG = Logger.getLogger(EquinoxCommandProviderGenerator.class.getName());
    private static final ClassPool POOL = ClassPool.getDefault();

    public static Object generate(Object service, String groupName, Map<String, String> commands, String suffix) throws Exception {
        CtClass ctClass = POOL.makeClass(AbstractEquinoxCommandProvider.class.getName() + suffix);
        try {
            HashSet<String> commandHelps = new HashSet<String>();
            if (!ctClass.isFrozen()) {
                CtClass abstractCtClass = POOL.getCtClass(AbstractEquinoxCommandProvider.class.getName());
                ctClass.setSuperclass(abstractCtClass);
                CtClass serviceCtClass = POOL.getCtClass(Object.class.getName());
                CtClass stringCtClass = POOL.getCtClass(String.class.getName());
                CtClass setCtClass = POOL.getCtClass(Set.class.getName());
                CtConstructor ctConstructor = new CtConstructor(new CtClass[]{serviceCtClass, stringCtClass, setCtClass}, ctClass);
                ctConstructor.setModifiers(1);
                ctConstructor.setBody("super($1, $2, $3);");
                ctClass.addConstructor(ctConstructor);
                CtClass interpreterCtClass = POOL.getCtClass(CommandInterpreter.class.getName());
                Set<String> names = commands.keySet();
                for (String name : names) {
                    if (!EquinoxCommandProviderGenerator.isMethodAvailable(service, name)) continue;
                    CtMethod ctMethod = new CtMethod(CtClass.voidType, "_" + name, new CtClass[]{interpreterCtClass}, ctClass);
                    ctMethod.setModifiers(1);
                    ctMethod.setBody("runCommand(\"" + name + "\", $1);");
                    ctClass.addMethod(ctMethod);
                    commandHelps.add(commands.get(name));
                }
            }
            Class aClass = ctClass.toClass(EquinoxCommandProviderGenerator.class.getClassLoader());
            Constructor constructor = aClass.getConstructor(Object.class, String.class, Set.class);
            return constructor.newInstance(service, groupName, commandHelps);
        }
        catch (Exception e) {
            ctClass.detach();
            throw e;
        }
    }

    private static boolean isMethodAvailable(Object commandsProvider, String methodName) {
        try {
            commandsProvider.getClass().getMethod(methodName, PrintWriter.class, String[].class);
            return true;
        }
        catch (NoSuchMethodException e) {
            LOG.log(Level.WARNING, "Unable to find Console Command: " + methodName, e);
            return false;
        }
    }

    public static void clean(String suffix) {
        try {
            CtClass ctClass = POOL.getCtClass(AbstractEquinoxCommandProvider.class.getName() + suffix);
            ctClass.defrost();
            ctClass.detach();
        }
        catch (NotFoundException e) {
            LOG.log(Level.WARNING, "Unable to clean Console Service. " + e.getMessage(), e);
        }
    }

    static {
        POOL.appendClassPath((ClassPath)new ClassClassPath(AbstractEquinoxCommandProvider.class));
        POOL.appendClassPath((ClassPath)new ClassClassPath(CommandInterpreter.class));
    }
}

