/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.shell.felixgogo;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.service.command.CommandSession;

public class AbstractFelixCommandsService {
    private static final Logger LOG = Logger.getLogger(AbstractFelixCommandsService.class.getName());
    private Object service;

    public AbstractFelixCommandsService(Object service) {
        this.service = service;
    }

    protected void runCommand(String commandName, CommandSession session, String[] params) {
        try {
            Method method = this.service.getClass().getMethod(commandName, PrintWriter.class, String[].class);
            PrintWriter printWriter = new PrintWriter(session.getConsole());
            method.invoke(this.service, printWriter, params);
            printWriter.flush();
        }
        catch (NoSuchMethodException e) {
            session.getConsole().println("No such command: " + commandName);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to execute command: " + commandName + " with args: " + Arrays.toString(params), e);
            e.printStackTrace(session.getConsole());
        }
    }
}

