/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.shell.felixgogo;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.knowhowlab.osgi.shell.felixgogo.AbstractFelixCommandsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixGogoCommandsServiceGenerator {
    private static final Logger LOG = Logger.getLogger(FelixGogoCommandsServiceGenerator.class.getName());
    private static final ClassPool POOL = ClassPool.getDefault();

    public static Object generate(Object service, Map<String, String> commands, String suffix) throws Exception {
        CtClass ctClass = POOL.makeClass(AbstractFelixCommandsService.class.getName() + suffix);
        try {
            if (!ctClass.isFrozen()) {
                ClassFile ccFile = ctClass.getClassFile();
                ccFile.setVersionToJava5();
                ConstPool constPool = ccFile.getConstPool();
                CtClass abstractCtClass = POOL.getCtClass(AbstractFelixCommandsService.class.getName());
                ctClass.setSuperclass(abstractCtClass);
                CtClass serviceCtClass = POOL.getCtClass(Object.class.getName());
                CtConstructor ctConstructor = new CtConstructor(new CtClass[]{serviceCtClass}, ctClass);
                ctConstructor.setModifiers(1);
                ctConstructor.setBody("super($1);");
                ctClass.addConstructor(ctConstructor);
                CtClass sessionCtClass = POOL.getCtClass(CommandSession.class.getName());
                CtClass stringArrayCtClass = POOL.getCtClass(String[].class.getName());
                Set<String> names = commands.keySet();
                for (String name : names) {
                    if (!FelixGogoCommandsServiceGenerator.isMethodAvailable(service, name)) continue;
                    CtMethod ctMethod = new CtMethod(CtClass.voidType, name, new CtClass[]{sessionCtClass, stringArrayCtClass}, ctClass);
                    ctMethod.setModifiers(1);
                    ctMethod.setBody("runCommand(\"" + name + "\", $1, $2);");
                    ctClass.addMethod(ctMethod);
                    AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                    Annotation annotation = new Annotation(Descriptor.class.getName(), constPool);
                    annotation.addMemberValue("value", (MemberValue)new StringMemberValue(commands.get(name), constPool));
                    annotationsAttribute.addAnnotation(annotation);
                    ctMethod.getMethodInfo().addAttribute((AttributeInfo)annotationsAttribute);
                }
            }
            Class aClass = ctClass.toClass(FelixGogoCommandsServiceGenerator.class.getClassLoader());
            Constructor constructor = aClass.getConstructor(Object.class);
            return constructor.newInstance(service);
        }
        catch (Exception e) {
            ctClass.detach();
            throw e;
        }
    }

    private static boolean isMethodAvailable(Object commandsProvider, String methodName) {
        try {
            commandsProvider.getClass().getMethod(methodName, PrintWriter.class, String[].class);
            return true;
        }
        catch (NoSuchMethodException e) {
            LOG.log(Level.WARNING, "Unable to find Console Command: " + methodName, e);
            return false;
        }
    }

    public static void clean(String suffix) {
        try {
            CtClass ctClass = POOL.getCtClass(AbstractFelixCommandsService.class.getName() + suffix);
            ctClass.defrost();
            ctClass.detach();
        }
        catch (NotFoundException e) {
            LOG.log(Level.WARNING, "Unable to clean Console Service. " + e.getMessage(), e);
        }
    }

    static {
        POOL.appendClassPath((ClassPath)new ClassClassPath(AbstractFelixCommandsService.class));
    }
}

