/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.shell.felix;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.shell.Command;

public class FelixCommand
implements Command {
    private static final Logger LOG = Logger.getLogger(FelixCommand.class.getName());
    private String name;
    private String usage;
    private Object service;
    private Method method;

    public FelixCommand(String name, String usage, Object service) throws NoSuchMethodException {
        this.name = name;
        this.usage = usage;
        this.service = service;
        this.method = service.getClass().getMethod(name, PrintWriter.class, String[].class);
    }

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getShortDescription() {
        return this.usage;
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        Object[] args;
        String[] parsedLine = line.split(" ");
        if (parsedLine.length <= 1) {
            args = new String[]{};
        } else {
            args = new String[parsedLine.length - 1];
            System.arraycopy(parsedLine, 1, args, 0, args.length);
        }
        try {
            PrintWriter writer = new PrintWriter(out, true);
            this.method.invoke(this.service, writer, args);
            writer.flush();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to execute command: " + this.name + " with args: " + Arrays.toString(args), e);
            e.printStackTrace(err);
        }
    }
}

