/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.shell.knopflerfish;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import org.knopflerfish.service.console.CommandGroup;
import org.knowhowlab.osgi.shell.knopflerfish.KnopflerfishCommandGroup;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private static final String COMMANDS_DESCRIPTION_PROPERTY = "org.knowhowlab.osgi.shell.commands";
    private static final String GROUP_ID_PROPERTY = "org.knowhowlab.osgi.shell.group.id";
    private static final String GROUP_NAME_PROPERTY = "org.knowhowlab.osgi.shell.group.name";
    private static final String SHELL_COMMANDS_SERVICE_FILTER = "(&(org.knowhowlab.osgi.shell.commands=*)(org.knowhowlab.osgi.shell.group.id=*)(org.knowhowlab.osgi.shell.group.name=*))";
    private BundleContext bc;
    private ServiceTracker shellCommandsTracker;
    private Map<ServiceReference, ServiceRegistration> commandRegistrations = new HashMap<ServiceReference, ServiceRegistration>();

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        this.shellCommandsTracker = new ServiceTracker(this.bc, this.bc.createFilter(SHELL_COMMANDS_SERVICE_FILTER), (ServiceTrackerCustomizer)new ShellCommandsCustomizer());
        this.shellCommandsTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.shellCommandsTracker.close();
        this.shellCommandsTracker = null;
        this.bc = null;
    }

    private boolean isValidCommandMethod(Object service, String commandName) {
        try {
            service.getClass().getMethod(commandName, PrintWriter.class, String[].class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private class ShellCommandsCustomizer
    implements ServiceTrackerCustomizer {
        private ShellCommandsCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            String[][] commands;
            Object groupId = reference.getProperty(Activator.GROUP_ID_PROPERTY);
            if (groupId == null || !(groupId instanceof String)) {
                LOG.warning("org.knowhowlab.osgi.shell.group.id property is null or invalid. Ignore service");
                return null;
            }
            Object groupName = reference.getProperty(Activator.GROUP_NAME_PROPERTY);
            if (groupName == null || !(groupName instanceof String)) {
                LOG.warning("org.knowhowlab.osgi.shell.group.name property is null or invalid. Ignore service");
                return null;
            }
            Object commandsDescription = reference.getProperty(Activator.COMMANDS_DESCRIPTION_PROPERTY);
            if (commandsDescription == null) {
                LOG.warning("org.knowhowlab.osgi.shell.commands property is null. Ignore service");
                return null;
            }
            if (!(commandsDescription instanceof String[][])) {
                LOG.warning("org.knowhowlab.osgi.shell.commands property has wrong format: not String[][]");
                return null;
            }
            Object service = Activator.this.bc.getService(reference);
            KnopflerfishCommandGroup commandGroup = new KnopflerfishCommandGroup((String)groupId, (String)groupName, service);
            for (String[] commandInfo : commands = (String[][])commandsDescription) {
                if (commandInfo == null) continue;
                if (commandInfo.length != 2) {
                    LOG.warning("org.knowhowlab.osgi.shell.commands property has wrong format: not String[][]");
                    continue;
                }
                String commandName = commandInfo[0];
                String commandHelp = commandInfo[1];
                if (!Activator.this.isValidCommandMethod(service, commandName)) continue;
                commandGroup.addCommandHelp(commandHelp);
            }
            if (commandGroup.getCommandsCount() > 0) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                Integer ranking = (Integer)reference.getProperty("service.ranking");
                if (ranking != null) {
                    ((Dictionary)props).put("service.ranking", ranking);
                }
                ((Dictionary)props).put("groupName", commandGroup.getGroupName());
                Activator.this.commandRegistrations.put(reference, Activator.this.bc.registerService(CommandGroup.class.getName(), (Object)commandGroup, props));
                return service;
            }
            return null;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            ServiceRegistration registration = (ServiceRegistration)Activator.this.commandRegistrations.remove(reference);
            if (registration != null) {
                registration.unregister();
            }
            Activator.this.bc.ungetService(reference);
        }
    }
}

