/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.shell.knopflerfish;

import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.knopflerfish.service.console.CommandGroup;
import org.knopflerfish.service.console.Session;

public class KnopflerfishCommandGroup
implements CommandGroup {
    private static final Logger LOG = Logger.getLogger(KnopflerfishCommandGroup.class.getName());
    private String groupId;
    private String groupName;
    private Object service;
    private SortedSet<String> commandHelps = new TreeSet<String>();

    public KnopflerfishCommandGroup(String groupId, String groupName, Object service) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.service = service;
    }

    public String getGroupName() {
        return this.groupId;
    }

    public String getShortHelp() {
        return this.groupName;
    }

    public String getLongHelp() {
        StringBuilder builder = new StringBuilder();
        for (String command : this.commandHelps) {
            builder.append(command).append('\n');
        }
        return builder.toString();
    }

    public int execute(String[] lineArgs, Reader in, PrintWriter out, Session session) {
        if (lineArgs != null && lineArgs.length >= 1) {
            Object[] args;
            String commandName = lineArgs[0];
            if (lineArgs.length <= 1) {
                args = new String[]{};
            } else {
                args = new String[lineArgs.length - 1];
                System.arraycopy(lineArgs, 1, args, 0, args.length);
            }
            try {
                Method method = this.service.getClass().getMethod(commandName, PrintWriter.class, String[].class);
                method.invoke(this.service, out, args);
                out.flush();
            }
            catch (NoSuchMethodException e) {
                out.println("No such command: " + commandName);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to execute command: " + commandName + " with args: " + Arrays.toString(args), e);
                e.printStackTrace(out);
            }
        }
        return 0;
    }

    public void addCommandHelp(String commandHelp) {
        this.commandHelps.add(commandHelp);
    }

    public int getCommandsCount() {
        return this.commandHelps.size();
    }
}

