/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.assertions;

import junit.framework.Assert;
import org.knowhowlab.osgi.testing.assertions.OSGiAssert;
import org.knowhowlab.osgi.testing.utils.BundleUtils;
import org.knowhowlab.osgi.testing.utils.ServiceUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleAssert
extends OSGiAssert {
    private BundleAssert() {
    }

    public static void assertBundleState(int state, long bundleId) {
        BundleAssert.assertBundleState(null, state, bundleId);
    }

    public static void assertBundleState(String message, int state, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)String.format("Unknown bundle with ID: %d", bundleId), (Object)bundle);
        Assert.assertEquals((String)message, (int)state, (int)bundle.getState());
    }

    public static void assertBundleState(int state, String symbolicName) {
        BundleAssert.assertBundleState(null, state, symbolicName);
    }

    public static void assertBundleState(String message, int state, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s", symbolicName), (Object)bundle);
        Assert.assertEquals((String)message, (int)state, (int)bundle.getState());
    }

    public static void assertBundleState(int state, String symbolicName, Version version) {
        BundleAssert.assertBundleState(null, state, symbolicName, version);
    }

    public static void assertBundleState(String message, int state, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s and version: %s", symbolicName, version), (Object)bundle);
        Assert.assertEquals((String)message, (int)state, (int)bundle.getState());
    }

    public static void assertBundleAvailable(long bundleId) {
        BundleAssert.assertBundleAvailable(null, bundleId);
    }

    public static void assertBundleAvailable(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)message, (Object)bundle);
    }

    public static void assertBundleAvailable(String symbolicName) {
        BundleAssert.assertBundleAvailable(null, symbolicName);
    }

    public static void assertBundleAvailable(String message, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNotNull((String)message, (Object)bundle);
    }

    public static void assertBundleAvailable(String symbolicName, Version version) {
        BundleAssert.assertBundleAvailable(null, symbolicName, version);
    }

    public static void assertBundleAvailable(String message, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNotNull((String)message, (Object)bundle);
    }

    public static void assertBundleUnavailable(long bundleId) {
        BundleAssert.assertBundleUnavailable(null, bundleId);
    }

    public static void assertBundleUnavailable(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNull((String)message, (Object)bundle);
    }

    public static void assertBundleUnavailable(String symbolicName) {
        BundleAssert.assertBundleUnavailable(null, symbolicName);
    }

    public static void assertBundleUnavailable(String message, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNull((String)message, (Object)bundle);
    }

    public static void assertBundleUnavailable(String symbolicName, Version version) {
        BundleAssert.assertBundleUnavailable(null, symbolicName, version);
    }

    public static void assertBundleUnavailable(String message, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNull((String)message, (Object)bundle);
    }

    public static void assertFragment(long bundleId) {
        BundleAssert.assertFragment(null, bundleId);
    }

    public static void assertFragment(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)String.format("Unknown bundle with ID: %d", bundleId), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertFragment(String symbolicName) {
        BundleAssert.assertFragment(null, symbolicName);
    }

    public static void assertFragment(String message, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s", symbolicName), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertFragment(String symbolicName, Version version) {
        BundleAssert.assertFragment(null, symbolicName, version);
    }

    public static void assertFragment(String message, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s and version: %s", symbolicName, version), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertNotFragment(long bundleId) {
        BundleAssert.assertNotFragment(null, bundleId);
    }

    public static void assertNotFragment(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)String.format("Unknown bundle with ID: %d", bundleId), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertNotFragment(String symbolicName) {
        BundleAssert.assertNotFragment(null, symbolicName);
    }

    public static void assertNotFragment(String message, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s", symbolicName), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertNotFragment(String symbolicName, Version version) {
        BundleAssert.assertNotFragment(null, symbolicName, version);
    }

    public static void assertNotFragment(String message, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s and version: %s", symbolicName, version), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }
}

