/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.classloading;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.knowm.sundial.Job;
import org.quartz.classloading.ClassLoadHelper;
import org.quartz.classloading.InitThreadContextClassLoadHelper;
import org.quartz.classloading.LoadingLoaderClassLoadHelper;
import org.quartz.classloading.SimpleClassLoadHelper;
import org.quartz.classloading.ThreadContextClassLoadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadingClassLoadHelper
implements ClassLoadHelper {
    private final Logger logger = LoggerFactory.getLogger(CascadingClassLoadHelper.class);
    private LinkedList<ClassLoadHelper> loadHelpers;
    private ClassLoadHelper bestCandidate;

    @Override
    public void initialize() {
        this.loadHelpers = new LinkedList();
        this.loadHelpers.add(new LoadingLoaderClassLoadHelper());
        this.loadHelpers.add(new SimpleClassLoadHelper());
        this.loadHelpers.add(new ThreadContextClassLoadHelper());
        this.loadHelpers.add(new InitThreadContextClassLoadHelper());
        for (ClassLoadHelper loadHelper : this.loadHelpers) {
            loadHelper.initialize();
        }
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.loadClass(name);
            }
            catch (Throwable t) {
                this.bestCandidate = null;
            }
        }
        Throwable throwable = null;
        Class clazz = null;
        ClassLoadHelper loadHelper2 = null;
        for (ClassLoadHelper loadHelper2 : this.loadHelpers) {
            try {
                clazz = loadHelper2.loadClass(name);
                break;
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (clazz == null) {
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            throw new ClassNotFoundException(String.format("Unable to load class %s by any known loaders.", name), throwable);
        }
        this.bestCandidate = loadHelper2;
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        if (this.bestCandidate != null && (result = this.bestCandidate.getResource(name)) == null) {
            this.bestCandidate = null;
        }
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResource(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream result = null;
        if (this.bestCandidate != null && (result = this.bestCandidate.getResourceAsStream(name)) == null) {
            this.bestCandidate = null;
        }
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResourceAsStream(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    public Set<Class<? extends Job>> getJobClasses(String pkgname) {
        HashSet<Class<? extends Job>> classes = new HashSet<Class<? extends Job>>();
        String relPath = pkgname.replace('.', '/');
        URL resource = this.getResource(relPath);
        if (resource == null) {
            throw new RuntimeException("Unexpected problem: No resource for " + relPath);
        }
        this.logger.info("Package: '" + pkgname + "' becomes Resource: '" + resource.toString() + "'");
        if (resource.toString().startsWith("jar:")) {
            this.processJarfile(resource, pkgname, classes);
        } else {
            this.processDirectory(new File(resource.getPath()), pkgname, classes);
        }
        return classes;
    }

    private void processDirectory(File directory, String pkgname, Set<Class<? extends Job>> classes) {
        this.logger.debug("Reading Directory '" + directory + "'");
        String[] files = directory.list();
        for (int i = 0; i < files.length; ++i) {
            File subdir;
            String fileName = files[i];
            String className = null;
            if (fileName.endsWith(".class")) {
                className = pkgname + '.' + fileName.substring(0, fileName.length() - 6);
            }
            this.logger.debug("FileName '" + fileName + "'  =>  class '" + className + "'");
            if (className != null) {
                this.filterJobClassWithExceptionCatch(className, classes);
            }
            if (!(subdir = new File(directory, fileName)).isDirectory()) continue;
            this.processDirectory(subdir, pkgname + '.' + fileName, classes);
        }
    }

    private void processJarfile(URL resource, String pkgname, Set<Class<? extends Job>> classes) {
        JarFile jarFile;
        String relPath = pkgname.replace('.', '/');
        String resPath = resource.getPath().replace("%20", " ");
        String jarPath = resPath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
        this.logger.debug("Reading JAR file: '" + jarPath + "'");
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException reading JAR File '" + jarPath + "'", e);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            String className = null;
            if (entryName.endsWith(".class") && entryName.startsWith(relPath) && entryName.length() > relPath.length() + "/".length()) {
                className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            }
            this.logger.debug("JarEntry '" + entryName + "'  =>  class '" + className + "'");
            if (className == null) continue;
            this.filterJobClassWithExceptionCatch(className, classes);
        }
    }

    private void filterJobClassWithExceptionCatch(String className, Set<Class<? extends Job>> classes) {
        try {
            Class clazz = this.loadClass(className);
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return;
            }
            if (Modifier.isInterface(clazz.getModifiers())) {
                return;
            }
            if (Job.class.isAssignableFrom(clazz)) {
                classes.add(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected ClassNotFoundException loading class '" + className + "'");
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.bestCandidate == null ? Thread.currentThread().getContextClassLoader() : this.bestCandidate.getClassLoader();
    }
}

