/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.xml;

import org.quartz.core.Scheduler;
import org.quartz.exceptions.SchedulerException;
import org.quartz.plugins.SchedulerPlugin;
import org.quartz.plugins.xml.XMLSchedulingDataProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLSchedulingDataProcessorPlugin
implements SchedulerPlugin {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Scheduler scheduler;
    private boolean failOnFileNotFound = true;
    private String fileName = "jobs.xml";
    private long scanInterval = 0L;

    private Scheduler getScheduler() {
        return this.scheduler;
    }

    public String getFileNames() {
        return this.fileName;
    }

    public long getScanInterval() {
        return this.scanInterval / 1000L;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval * 1000L;
    }

    public boolean isFailOnFileNotFound() {
        return this.failOnFileNotFound;
    }

    public void setFailOnFileNotFound(boolean failOnFileNotFound) {
        this.failOnFileNotFound = failOnFileNotFound;
    }

    @Override
    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.logger.info("Initializing XMLSchedulingDataProcessorPlugin Plug-in.");
        this.scheduler = scheduler;
    }

    @Override
    public void start() {
        try {
            XMLSchedulingDataProcessor processor = new XMLSchedulingDataProcessor(this.scheduler.getCascadingClassLoadHelper());
            processor.processFile("jobs.xml", this.failOnFileNotFound);
            processor.scheduleJobs(this.getScheduler());
        }
        catch (Exception e) {
            this.logger.error("Error scheduling jobs: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
    }
}

