/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.sundial;

import org.knowm.sundial.JobContainer;
import org.knowm.sundial.SundialJobScheduler;
import org.knowm.sundial.exceptions.JobInterruptException;
import org.knowm.sundial.exceptions.RequiredParameterException;
import org.quartz.core.JobExecutionContext;
import org.quartz.exceptions.JobExecutionException;
import org.quartz.exceptions.UnableToInterruptJobException;
import org.quartz.jobs.InterruptableJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job
extends JobContainer
implements InterruptableJob {
    private final Logger logger = LoggerFactory.getLogger(Job.class);

    @Override
    public final void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (SundialJobScheduler.getGlobalLock()) {
            this.logger.info("Global Lock in place! Job aborted.");
            return;
        }
        try {
            this.initContextContainer(jobExecutionContext);
            this.doRun();
        }
        catch (RequiredParameterException requiredParameterException) {
        }
        catch (JobInterruptException jobInterruptException) {
        }
        catch (Exception e) {
            this.logger.error("Error executing Job! Job aborted!!!", (Throwable)e);
        }
        finally {
            this.cleanup();
            this.destroyContext();
        }
    }

    @Override
    public void interrupt() throws UnableToInterruptJobException {
        this.setTerminate();
        this.logger.info("Interrupt called!");
    }

    public void cleanup() {
    }

    public abstract void doRun() throws JobInterruptException;
}

