/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.sundial;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import org.knowm.sundial.Job;
import org.knowm.sundial.exceptions.SundialSchedulerException;
import org.quartz.builders.CronTriggerBuilder;
import org.quartz.builders.JobBuilder;
import org.quartz.builders.SimpleTriggerBuilder;
import org.quartz.core.JobExecutionContext;
import org.quartz.core.Scheduler;
import org.quartz.core.SchedulerFactory;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.JobDataMap;
import org.quartz.jobs.JobDetail;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SundialJobScheduler {
    static Logger logger = LoggerFactory.getLogger(SundialJobScheduler.class);
    private static Scheduler scheduler = null;
    private static boolean globalLock = false;
    private static ServletContext servletContext = null;

    public static void startScheduler() throws SundialSchedulerException {
        SundialJobScheduler.startScheduler(10, null);
    }

    public static void startScheduler(int threadPoolSize) throws SundialSchedulerException {
        SundialJobScheduler.startScheduler(threadPoolSize, null);
    }

    public static void startScheduler(String annotatedJobsPackageName) throws SundialSchedulerException {
        SundialJobScheduler.startScheduler(10, annotatedJobsPackageName);
    }

    public static void startScheduler(int threadPoolSize, String annotatedJobsPackageName) throws SundialSchedulerException {
        try {
            SundialJobScheduler.createScheduler(threadPoolSize, annotatedJobsPackageName);
            SundialJobScheduler.getScheduler().start();
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("COULD NOT START SUNDIAL SCHEDULER!!!", e);
        }
    }

    public static Scheduler createScheduler(int threadPoolSize, String annotatedJobsPackageName) throws SundialSchedulerException {
        if (scheduler == null) {
            try {
                scheduler = new SchedulerFactory().getScheduler(threadPoolSize, annotatedJobsPackageName);
            }
            catch (SchedulerException e) {
                throw new SundialSchedulerException("COULD NOT CREATE SUNDIAL SCHEDULER!!!", e);
            }
        }
        return scheduler;
    }

    public static Scheduler createScheduler(SchedulerFactory schedulerFactory) throws SundialSchedulerException {
        if (scheduler == null) {
            try {
                scheduler = schedulerFactory.getScheduler();
            }
            catch (SchedulerException e) {
                throw new SundialSchedulerException("COULD NOT CREATE SUNDIAL SCHEDULER!!!", e);
            }
        }
        return scheduler;
    }

    public static Scheduler getScheduler() {
        if (scheduler == null) {
            logger.warn("Scheduler has not yet been created!!! Call \"createScheduler\" first.");
        }
        return scheduler;
    }

    public static void toggleGlobalLock() {
        globalLock = !globalLock;
    }

    public static void lockScheduler() {
        globalLock = true;
    }

    public static void unlockScheduler() {
        globalLock = false;
    }

    public static boolean getGlobalLock() {
        return globalLock;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        SundialJobScheduler.servletContext = servletContext;
    }

    public static void addJob(String jobName, Class<? extends Job> jobClass) throws SundialSchedulerException {
        SundialJobScheduler.addJob(jobName, jobClass, null, false);
    }

    public static void addJob(String jobName, String jobClassName) throws SundialSchedulerException {
        SundialJobScheduler.addJob(jobName, jobClassName, null, false);
    }

    public static void addJob(String jobName, Class<? extends Job> jobClass, Map<String, Object> params, boolean isConcurrencyAllowed) throws SundialSchedulerException {
        try {
            JobDataMap jobDataMap = new JobDataMap();
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    jobDataMap.put(entry.getKey(), entry.getValue());
                }
            }
            JobDetail jobDetail = JobBuilder.newJobBuilder(jobClass).withIdentity(jobName).usingJobData(jobDataMap).isConcurrencyAllowed(isConcurrencyAllowed).build();
            SundialJobScheduler.getScheduler().addJob(jobDetail);
        }
        catch (SchedulerException e) {
            logger.error("ERROR ADDING JOB!!!", (Throwable)e);
            throw new SundialSchedulerException("ERROR ADDING JOB!!!", e);
        }
    }

    public static void addJob(String jobName, String jobClassName, Map<String, Object> params, boolean isConcurrencyAllowed) throws SundialSchedulerException {
        try {
            SundialJobScheduler.addJob(jobName, SundialJobScheduler.getScheduler().getCascadingClassLoadHelper().loadClass(jobClassName), params, isConcurrencyAllowed);
        }
        catch (ClassNotFoundException e) {
            throw new SundialSchedulerException("ERROR ADDING JOB!!!", e);
        }
    }

    public static void startJob(String jobName) throws SundialSchedulerException {
        try {
            SundialJobScheduler.getScheduler().triggerJob(jobName, null);
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("ERROR STARTING JOB!!!", e);
        }
    }

    public static void removeJob(String jobName) throws SundialSchedulerException {
        try {
            SundialJobScheduler.getScheduler().deleteJob(jobName);
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("ERROR REMOVING JOB!!!", e);
        }
    }

    public static void startJob(String jobName, Map<String, Object> params) throws SundialSchedulerException {
        try {
            JobDataMap jobDataMap = new JobDataMap();
            for (String key : params.keySet()) {
                jobDataMap.put(key, params.get(key));
            }
            SundialJobScheduler.getScheduler().triggerJob(jobName, jobDataMap);
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("ERROR STARTING JOB!!!", e);
        }
    }

    public static void stopJob(String jobName) throws SundialSchedulerException {
        try {
            List<JobExecutionContext> currentlyExecutingJobs = SundialJobScheduler.getScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : currentlyExecutingJobs) {
                String currentlyExecutingJobName = jobExecutionContext.getJobDetail().getName();
                if (currentlyExecutingJobName.equals(jobName)) {
                    logger.debug("Matching Job found. Now Stopping!");
                    if (jobExecutionContext.getJobInstance() instanceof Job) {
                        ((Job)jobExecutionContext.getJobInstance()).interrupt();
                        continue;
                    }
                    logger.warn("CANNOT STOP NON-INTERRUPTABLE JOB!!!");
                    continue;
                }
                logger.debug("Non-matching Job found. Not Stopping!");
            }
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("ERROR STOPPING JOB!!!", e);
        }
    }

    public static void stopJob(String jobName, String key, String pValue) throws SundialSchedulerException {
        logger.debug("key= " + key);
        logger.debug("value= " + pValue);
        try {
            List<JobExecutionContext> currentlyExecutingJobs = SundialJobScheduler.getScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : currentlyExecutingJobs) {
                String currentlyExecutingJobName = jobExecutionContext.getJobDetail().getName();
                if (currentlyExecutingJobName.equals(jobName)) {
                    if (jobExecutionContext.getJobInstance() instanceof Job) {
                        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
                        String value = jobDataMap.getString(key);
                        if (!(value != null & value.equalsIgnoreCase(pValue))) continue;
                        ((Job)jobExecutionContext.getJobInstance()).interrupt();
                        continue;
                    }
                    logger.warn("CANNOT STOP NON-INTERRUPTABLE JOB!!!");
                    continue;
                }
                logger.debug("Non-matching Job found. Not Stopping!");
            }
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("ERROR DURING STOP JOB!!!", e);
        }
    }

    public static void addCronTrigger(String triggerName, String jobName, String cronExpression) throws SundialSchedulerException {
        SundialJobScheduler.addCronTrigger(triggerName, jobName, cronExpression, null, null);
    }

    public static void addCronTrigger(String triggerName, String jobName, String cronExpression, Date startTime, Date endTime) throws SundialSchedulerException {
        try {
            CronTriggerBuilder cronTriggerBuilder = CronTriggerBuilder.cronTriggerBuilder(cronExpression);
            cronTriggerBuilder.withIdentity(triggerName).forJob(jobName).withPriority(5);
            if (startTime != null) {
                cronTriggerBuilder.startAt(startTime);
            }
            if (endTime != null) {
                cronTriggerBuilder.endAt(endTime);
            }
            OperableTrigger trigger = cronTriggerBuilder.build();
            SundialJobScheduler.getScheduler().scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            logger.error("ERROR ADDING CRON TRIGGER!!!", (Throwable)e);
            throw new SundialSchedulerException("ERROR ADDING CRON TRIGGER!!!", e);
        }
        catch (ParseException e) {
            throw new SundialSchedulerException("ERROR ADDING CRON TRIGGER!!!", e);
        }
    }

    public static void addSimpleTrigger(String triggerName, String jobName, int repeatCount, long repeatInterval) throws SundialSchedulerException {
        SundialJobScheduler.addSimpleTrigger(triggerName, jobName, repeatCount, repeatInterval, null, null);
    }

    public static void addSimpleTrigger(String triggerName, String jobName, int repeatCount, long repeatInterval, Date startTime, Date endTime) throws SundialSchedulerException {
        try {
            SimpleTriggerBuilder simpleTriggerBuilder = SimpleTriggerBuilder.simpleTriggerBuilder();
            simpleTriggerBuilder.withRepeatCount(repeatCount).withIntervalInMilliseconds(repeatInterval).withIdentity(triggerName).forJob(jobName);
            if (startTime != null) {
                simpleTriggerBuilder.startAt(startTime);
            }
            if (endTime != null) {
                simpleTriggerBuilder.endAt(endTime);
            }
            OperableTrigger trigger = simpleTriggerBuilder.build();
            SundialJobScheduler.getScheduler().scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("ERROR ADDING CRON TRIGGER!!!", e);
        }
    }

    public static void removeTrigger(String triggerName) throws SundialSchedulerException {
        try {
            SundialJobScheduler.getScheduler().unscheduleJob(triggerName);
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("ERROR REMOVING TRIGGER!!!", e);
        }
    }

    public static List<String> getAllJobNames() throws SundialSchedulerException {
        ArrayList<String> allJobNames = new ArrayList<String>();
        try {
            Set<String> allJobKeys = SundialJobScheduler.getScheduler().getJobKeys();
            for (String jobKey : allJobKeys) {
                allJobNames.add(jobKey);
            }
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("COULD NOT GET JOB NAMES!!!", e);
        }
        Collections.sort(allJobNames);
        return allJobNames;
    }

    public static Map<String, List<Trigger>> getAllJobsAndTriggers() throws SundialSchedulerException {
        TreeMap<String, List<Trigger>> allJobsMap = new TreeMap<String, List<Trigger>>();
        try {
            Set<String> allJobKeys = SundialJobScheduler.getScheduler().getJobKeys();
            for (String jobKey : allJobKeys) {
                List<Trigger> triggers = SundialJobScheduler.getScheduler().getTriggersOfJob(jobKey);
                allJobsMap.put(jobKey, triggers);
            }
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("COULD NOT GET JOB NAMES!!!", e);
        }
        return allJobsMap;
    }

    public static boolean isJobRunning(String jobName) throws SundialSchedulerException {
        try {
            List<JobExecutionContext> currentlyExecutingJobs = SundialJobScheduler.getScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : currentlyExecutingJobs) {
                String currentlyExecutingJobName = jobExecutionContext.getJobDetail().getName();
                if (!currentlyExecutingJobName.equals(jobName)) continue;
                logger.debug("Matching running Job found!");
                return true;
            }
        }
        catch (SchedulerException e) {
            throw new SundialSchedulerException("ERROR CHECKING RUNNING JOB!!!", e);
        }
        logger.debug("Matching running NOT Job found!");
        return false;
    }

    public static void shutdown() throws SundialSchedulerException {
        logger.debug("shutdown() called.");
        try {
            SundialJobScheduler.getScheduler().shutdown(true);
            scheduler = null;
        }
        catch (Exception e) {
            throw new SundialSchedulerException("COULD NOT SHUTDOWN SCHEDULER!!!", e);
        }
    }
}

