/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.sundial.plugins;

import java.text.ParseException;
import java.util.Set;
import java.util.TimeZone;
import org.knowm.sundial.Job;
import org.knowm.sundial.annotations.CronTrigger;
import org.knowm.sundial.annotations.SimpleTrigger;
import org.quartz.builders.CronTriggerBuilder;
import org.quartz.builders.JobBuilder;
import org.quartz.builders.SimpleTriggerBuilder;
import org.quartz.core.Scheduler;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.JobDataMap;
import org.quartz.jobs.JobDetail;
import org.quartz.plugins.SchedulerPlugin;
import org.quartz.triggers.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationJobTriggerPlugin
implements SchedulerPlugin {
    private final Logger logger = LoggerFactory.getLogger(AnnotationJobTriggerPlugin.class);
    private Scheduler scheduler;
    private final String packageName;
    private static final String SEPARATOR = ":";

    public AnnotationJobTriggerPlugin(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.logger.info("Initializing AnnotationJobTriggerPlugin Plug-in.");
        this.scheduler = scheduler;
    }

    @Override
    public void start() {
        this.logger.info("Loading annotated jobs from {}.", (Object)this.packageName);
        if (this.packageName != null) {
            Set<Class<? extends Job>> scheduledClasses = this.scheduler.getCascadingClassLoadHelper().getJobClasses(this.packageName);
            for (Class<? extends Job> jobClass : scheduledClasses) {
                SimpleTrigger simpleTrigger;
                CronTrigger cronTrigger = jobClass.getAnnotation(CronTrigger.class);
                if (cronTrigger != null) {
                    JobDataMap jobDataMap = new JobDataMap();
                    if (cronTrigger.jobDataMap() != null && cronTrigger.jobDataMap().length > 0) {
                        this.addToJobDataMap(jobDataMap, cronTrigger.jobDataMap());
                    }
                    JobDetail jobDetail = JobBuilder.newJobBuilder(jobClass).withIdentity(jobClass.getSimpleName()).isConcurrencyAllowed(cronTrigger.isConcurrencyAllowed()).usingJobData(jobDataMap).build();
                    try {
                        OperableTrigger trigger = this.buildCronTrigger(cronTrigger, jobClass.getSimpleName());
                        this.scheduler.scheduleJob(jobDetail, trigger);
                        this.logger.info("Scheduled job: {} with trigger: {}", (Object)jobDetail, (Object)trigger);
                    }
                    catch (Exception e) {
                        this.logger.warn("ANNOTATED JOB + TRIGGER NOT ADDED!", (Throwable)e);
                    }
                }
                if ((simpleTrigger = jobClass.getAnnotation(SimpleTrigger.class)) == null) continue;
                JobDataMap jobDataMap = new JobDataMap();
                if (simpleTrigger.jobDataMap() != null && simpleTrigger.jobDataMap().length > 0) {
                    this.addToJobDataMap(jobDataMap, simpleTrigger.jobDataMap());
                }
                JobDetail job = JobBuilder.newJobBuilder(jobClass).withIdentity(jobClass.getSimpleName()).isConcurrencyAllowed(simpleTrigger.isConcurrencyAllowed()).usingJobData(jobDataMap).build();
                try {
                    OperableTrigger trigger = this.buildSimpleTrigger(simpleTrigger, jobClass.getSimpleName());
                    this.scheduler.scheduleJob(job, trigger);
                    this.logger.info("Scheduled job {} with trigger {}", (Object)job, (Object)trigger);
                }
                catch (Exception e) {
                    this.logger.warn("ANNOTATED JOB + TRIGGER NOT ADDED!", (Throwable)e);
                }
            }
        } else {
            this.logger.info("Not loading any annotated Jobs. No package name provided. Use SundialJobScheduler.createScheduler() to set the package name.");
        }
    }

    public OperableTrigger buildCronTrigger(CronTrigger cronTrigger, String jobName) throws ParseException {
        if (cronTrigger.cron() != null && cronTrigger.cron().trim().length() > 0) {
            TimeZone tz = cronTrigger.timeZone() == null || cronTrigger.timeZone().length() < 1 ? null : TimeZone.getTimeZone(cronTrigger.timeZone());
            return CronTriggerBuilder.cronTriggerBuilder(cronTrigger.cron()).inTimeZone(tz).withIdentity(jobName + "-Trigger").forJob(jobName).withPriority(5).build();
        }
        throw new IllegalArgumentException("'cron' is required for the @CronTrigger annotation");
    }

    public OperableTrigger buildSimpleTrigger(SimpleTrigger simpleTrigger, String jobName) {
        return SimpleTriggerBuilder.simpleTriggerBuilder().withRepeatCount(simpleTrigger.repeatCount()).withIntervalInMilliseconds(simpleTrigger.timeUnit().toMillis(simpleTrigger.repeatInterval())).withIdentity(jobName + "-Trigger").forJob(jobName).withPriority(5).build();
    }

    private void addToJobDataMap(JobDataMap jobDataMap, String[] stringEncodedMap) {
        for (int i = 0; i < stringEncodedMap.length; ++i) {
            String[] keyValue = stringEncodedMap[i].split(SEPARATOR);
            if (keyValue == null || keyValue.length != 2) {
                this.logger.warn(stringEncodedMap[i] + " was not parsable!!! Skipping.");
                continue;
            }
            jobDataMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
    }

    @Override
    public void shutdown() {
    }
}

