/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.sundial;

import org.knowm.sundial.JobContext;
import org.knowm.sundial.exceptions.JobInterruptException;
import org.quartz.core.JobExecutionContext;

public abstract class JobContainer {
    private static ThreadLocal<JobContext> contextContainer = new ThreadLocal();
    private boolean terminate = false;

    protected void initContextContainer(JobExecutionContext jobExecutionContext) {
        JobContext jobContext = new JobContext();
        jobContext.addQuartzContext(jobExecutionContext);
        contextContainer.set(jobContext);
    }

    protected void destroyContext() {
        contextContainer.remove();
    }

    protected JobContext getJobContext() {
        return JobContainer.getContext();
    }

    private static JobContext getContext() {
        return contextContainer.get();
    }

    public void checkTerminated() {
        if (this.terminate) {
            throw new JobInterruptException();
        }
    }

    protected void setTerminate() {
        this.terminate = true;
    }
}

