/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.quartz.classloading.ClassLoadHelper;

class InitThreadContextClassLoadHelper
implements ClassLoadHelper {
    private ClassLoader initClassLoader;

    InitThreadContextClassLoadHelper() {
    }

    @Override
    public void initialize() {
        this.initClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return this.initClassLoader.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.initClassLoader.getResource(name);
    }

    @Override
    public List<URL> getResources(String name) {
        try {
            return Collections.list(this.initClassLoader.getResources(name));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.initClassLoader.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.initClassLoader;
    }
}

