/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.triggers;

import java.util.Arrays;
import java.util.Date;
import org.quartz.core.JobExecutionContext;
import org.quartz.exceptions.JobExecutionException;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.JobDataMap;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.Trigger;

public abstract class AbstractTrigger
implements OperableTrigger {
    private static final long serialVersionUID = -3904243490805975570L;
    protected Date startTime = null;
    protected Date endTime = null;
    protected Date nextFireTime = null;
    protected Date previousFireTime = null;
    private String name;
    private String jobName;
    private String description;
    private JobDataMap jobDataMap;
    private String calendarName = null;
    private String fireInstanceId = null;
    private int misfireInstruction = 0;
    private int priority = 5;

    protected abstract boolean validateMisfireInstruction(int var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Trigger name cannot be null or empty.");
        }
        this.name = name;
    }

    @Override
    public void setJobName(String jobName) {
        if (jobName == null || jobName.trim().length() == 0) {
            throw new IllegalArgumentException("Job name cannot be null or empty.");
        }
        this.jobName = jobName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    @Override
    public String getCalendarName() {
        return this.calendarName;
    }

    @Override
    public JobDataMap getJobDataMap() {
        if (this.jobDataMap == null) {
            this.jobDataMap = new JobDataMap();
        }
        return this.jobDataMap;
    }

    @Override
    public void setJobDataMap(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getMisfireInstruction() {
        return this.misfireInstruction;
    }

    @Override
    public void setMisfireInstruction(int misfireInstruction) {
        if (!this.validateMisfireInstruction(misfireInstruction)) {
            throw new IllegalArgumentException("The misfire instruction code is invalid for this type of trigger.");
        }
        this.misfireInstruction = misfireInstruction;
    }

    @Override
    public Trigger.CompletedExecutionInstruction executionComplete(JobExecutionContext context, JobExecutionException result) {
        if (result != null && result.refireImmediately()) {
            return Trigger.CompletedExecutionInstruction.RE_EXECUTE_JOB;
        }
        if (result != null && result.unscheduleFiringTrigger()) {
            return Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE;
        }
        if (result != null && result.unscheduleAllTriggers()) {
            return Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE;
        }
        if (!this.mayFireAgain()) {
            return Trigger.CompletedExecutionInstruction.DELETE_TRIGGER;
        }
        return Trigger.CompletedExecutionInstruction.NOOP;
    }

    @Override
    public void validate() throws SchedulerException {
        if (this.name == null) {
            throw new SchedulerException("Trigger's name cannot be null");
        }
        if (this.jobName == null) {
            throw new SchedulerException("Trigger's related Job's name cannot be null");
        }
    }

    @Override
    public void setFireInstanceId(String id) {
        this.fireInstanceId = id;
    }

    @Override
    public String getFireInstanceId() {
        return this.fireInstanceId;
    }

    @Override
    public int compareTo(Trigger other) {
        if (other.getName() == null && this.getName() == null) {
            return 0;
        }
        if (other.getName() == null) {
            return -1;
        }
        if (this.getName() == null) {
            return 1;
        }
        return this.getName().compareTo(other.getName());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (other.getName() == null || this.getName() == null) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        if (this.getName() == null) {
            return super.hashCode();
        }
        return this.getName().hashCode();
    }

    @Override
    public Object clone() {
        AbstractTrigger copy;
        try {
            copy = (AbstractTrigger)super.clone();
            if (this.jobDataMap != null) {
                copy.jobDataMap = this.jobDataMap.shallowCopy();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return copy;
    }

    public String toString() {
        return "Trigger '" + this.getName() + "',  triggerClass: " + this.getClass().getSimpleName() + ", jobName: " + this.getJobName() + ", jobDataMap: " + (this.jobDataMap == null ? "empty" : Arrays.toString(this.jobDataMap.entrySet().toArray())) + ", calendar: " + this.getCalendarName() + ", misfireInstruction: " + this.getMisfireInstruction() + ", priority: " + this.getPriority() + ", nextFireTime: " + this.getNextFireTime();
    }
}

