/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.triggers;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.triggers.AbstractTrigger;
import org.quartz.triggers.CronExpression;
import org.quartz.triggers.CronTrigger;

public class CronTriggerImpl
extends AbstractTrigger
implements CronTrigger {
    private static final long serialVersionUID = -8644953146451592766L;
    private CronExpression cronEx = null;
    private transient TimeZone timeZone = null;

    public CronTriggerImpl() {
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    @Override
    public Object clone() {
        CronTriggerImpl copy = (CronTriggerImpl)super.clone();
        if (this.cronEx != null) {
            copy.setCronExpression(new CronExpression(this.cronEx));
        }
        return copy;
    }

    public void setCronExpression(String cronExpression) throws ParseException {
        TimeZone origTz = this.getTimeZone();
        this.cronEx = new CronExpression(cronExpression);
        this.cronEx.setTimeZone(origTz);
    }

    @Override
    public String getCronExpression() {
        return this.cronEx == null ? null : this.cronEx.getCronExpression();
    }

    public void setCronExpression(CronExpression cronExpression) {
        this.cronEx = cronExpression;
        this.timeZone = cronExpression.getTimeZone();
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && startTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(startTime);
        cl.set(14, 0);
        this.startTime = cl.getTime();
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    @Override
    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    @Override
    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    @Override
    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.cronEx != null) {
            return this.cronEx.getTimeZone();
        }
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (this.cronEx != null) {
            this.cronEx.setTimeZone(timeZone);
        }
        this.timeZone = timeZone;
    }

    @Override
    public Date getFireTimeAfter(Date afterTime) {
        if (afterTime == null) {
            afterTime = new Date();
        }
        if (this.getStartTime().after(afterTime)) {
            afterTime = new Date(this.getStartTime().getTime() - 1000L);
        }
        if (this.getEndTime() != null && afterTime.compareTo(this.getEndTime()) >= 0) {
            return null;
        }
        Date pot = this.getTimeAfter(afterTime);
        if (this.getEndTime() != null && pot != null && pot.after(this.getEndTime())) {
            return null;
        }
        return pot;
    }

    @Override
    public Date getFinalFireTime() {
        Date resultTime;
        if (this.getEndTime() != null) {
            resultTime = this.getTimeBefore(new Date(this.getEndTime().getTime() + 1000L));
        } else {
            Date date = resultTime = this.cronEx == null ? null : this.cronEx.getFinalFireTime();
        }
        if (resultTime != null && this.getStartTime() != null && resultTime.before(this.getStartTime())) {
            return null;
        }
        return resultTime;
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    protected boolean validateMisfireInstruction(int misfireInstruction) {
        if (misfireInstruction < 0) {
            return false;
        }
        return misfireInstruction <= 2;
    }

    @Override
    public void updateAfterMisfire(org.quartz.core.Calendar cal) {
        int instr = this.getMisfireInstruction();
        if (instr == -1) {
            return;
        }
        if (instr == 0) {
            instr = 1;
        }
        if (instr == 2) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime())) {
                newFireTime = this.getFireTimeAfter(newFireTime);
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 1) {
            this.setNextFireTime(new Date());
        }
    }

    @Override
    public void triggered(org.quartz.core.Calendar calendar) {
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    @Override
    public Date computeFirstFireTime(org.quartz.core.Calendar calendar) {
        this.nextFireTime = this.getFireTimeAfter(new Date(this.getStartTime().getTime() - 1000L));
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
        return this.nextFireTime;
    }

    @Override
    public String getExpressionSummary() {
        return this.cronEx == null ? null : this.cronEx.getExpressionSummary();
    }

    private Date getTimeAfter(Date afterTime) {
        return this.cronEx == null ? null : this.cronEx.getTimeAfter(afterTime);
    }

    private Date getTimeBefore(Date endTime) {
        return this.cronEx == null ? null : this.cronEx.getTimeBefore(endTime);
    }

    @Override
    public String toString() {
        return super.toString() + ", cronEx: " + this.getCronExpression() + ", timeZone: " + this.getTimeZone().getID();
    }
}

