/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.sundial;

import org.knowm.sundial.JobContainer;
import org.knowm.sundial.SundialJobScheduler;
import org.knowm.sundial.exceptions.JobInterruptException;
import org.knowm.sundial.exceptions.RequiredParameterException;
import org.quartz.core.JobExecutionContext;
import org.quartz.exceptions.JobExecutionException;
import org.quartz.jobs.InterruptableJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job
extends JobContainer
implements InterruptableJob {
    private final Logger logger = LoggerFactory.getLogger(Job.class);

    @Override
    public final void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (SundialJobScheduler.getGlobalLock()) {
            this.logger.info("Global Lock in place! Job aborted.");
            return;
        }
        try {
            this.initContextContainer(jobExecutionContext);
            this.doRun();
        }
        catch (RequiredParameterException requiredParameterException) {
        }
        catch (JobInterruptException jobInterruptException) {
        }
        catch (Exception e) {
            this.logger.error(String.format("Job [%s] aborted due to execution error: %s", jobExecutionContext.getJobDetail().getName(), e.getMessage()), (Throwable)e);
        }
        finally {
            this.cleanup();
            this.destroyContext();
        }
    }

    @Override
    public void interrupt() {
        this.logger.debug("Interrupt called!");
        this.setTerminate();
    }

    public void cleanup() {
    }

    public abstract void doRun() throws JobInterruptException;
}

