/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.builders;

import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.builders.TriggerBuilder;
import org.quartz.jobs.JobDataMap;
import org.quartz.triggers.CronExpression;
import org.quartz.triggers.CronTriggerImpl;
import org.quartz.triggers.OperableTrigger;

public class CronTriggerBuilder
extends TriggerBuilder {
    private String cronExpression;
    private TimeZone tz = null;
    private int misfireInstruction = 0;

    private CronTriggerBuilder(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public static CronTriggerBuilder cronTriggerBuilder(String cronExpression) throws ParseException {
        CronExpression.validateExpression(cronExpression);
        return new CronTriggerBuilder(cronExpression);
    }

    @Override
    public OperableTrigger instantiate() {
        CronTriggerImpl ct = new CronTriggerImpl();
        try {
            ct.setCronExpression(this.cronExpression);
        }
        catch (ParseException e) {
            throw new RuntimeException("CronExpression '" + this.cronExpression + "' is invalid, which should not be possible, please report bug to Quartz developers.");
        }
        ct.setTimeZone(this.tz);
        ct.setMisfireInstruction(this.misfireInstruction);
        return ct;
    }

    public CronTriggerBuilder inTimeZone(TimeZone tz) {
        this.tz = tz;
        return this;
    }

    public CronTriggerBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public CronTriggerBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }

    @Override
    public CronTriggerBuilder withIdentity(String name) {
        return (CronTriggerBuilder)super.withIdentity(name);
    }

    @Override
    public CronTriggerBuilder withDescription(String description) {
        return (CronTriggerBuilder)super.withDescription(description);
    }

    @Override
    public CronTriggerBuilder withPriority(int priority) {
        return (CronTriggerBuilder)super.withPriority(priority);
    }

    @Override
    public CronTriggerBuilder modifiedByCalendar(String calendarName) {
        return (CronTriggerBuilder)super.modifiedByCalendar(calendarName);
    }

    @Override
    public CronTriggerBuilder startNow() {
        return (CronTriggerBuilder)super.startNow();
    }

    @Override
    public CronTriggerBuilder startAt(Date startTime) {
        return (CronTriggerBuilder)super.startAt(startTime);
    }

    @Override
    public CronTriggerBuilder endAt(Date endTime) {
        return (CronTriggerBuilder)super.endAt(endTime);
    }

    @Override
    public CronTriggerBuilder forJob(String jobName) {
        return (CronTriggerBuilder)super.forJob(jobName);
    }

    @Override
    public CronTriggerBuilder usingJobData(JobDataMap newJobDataMap) {
        return (CronTriggerBuilder)super.usingJobData(newJobDataMap);
    }
}

