/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.classloading;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.knowm.sundial.Job;
import org.quartz.classloading.ClassLoadHelper;
import org.quartz.classloading.InitThreadContextClassLoadHelper;
import org.quartz.classloading.LoadingLoaderClassLoadHelper;
import org.quartz.classloading.SimpleClassLoadHelper;
import org.quartz.classloading.ThreadContextClassLoadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadingClassLoadHelper
implements ClassLoadHelper {
    private final Logger logger = LoggerFactory.getLogger(CascadingClassLoadHelper.class);
    private LinkedList<ClassLoadHelper> loadHelpers;
    private ClassLoadHelper bestCandidate;

    @Override
    public void initialize() {
        this.loadHelpers = new LinkedList();
        this.loadHelpers.add(new LoadingLoaderClassLoadHelper());
        this.loadHelpers.add(new SimpleClassLoadHelper());
        this.loadHelpers.add(new ThreadContextClassLoadHelper());
        this.loadHelpers.add(new InitThreadContextClassLoadHelper());
        for (ClassLoadHelper loadHelper : this.loadHelpers) {
            loadHelper.initialize();
        }
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.loadClass(name);
            }
            catch (Throwable t) {
                this.bestCandidate = null;
            }
        }
        Throwable throwable = null;
        Class clazz = null;
        ClassLoadHelper loadHelper2 = null;
        for (ClassLoadHelper loadHelper2 : this.loadHelpers) {
            try {
                clazz = loadHelper2.loadClass(name);
                break;
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (clazz == null) {
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            throw new ClassNotFoundException(String.format("Unable to load class %s by any known loaders.", name), throwable);
        }
        this.bestCandidate = loadHelper2;
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        if (this.bestCandidate != null && (result = this.bestCandidate.getResource(name)) == null) {
            this.bestCandidate = null;
        }
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResource(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    @Override
    public List<URL> getResources(String name) {
        List<URL> result = null;
        if (this.bestCandidate != null && ((result = this.bestCandidate.getResources(name)) == null || result.isEmpty())) {
            this.bestCandidate = null;
        }
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && ((result = (loadHelper = (ClassLoadHelper)iter.next()).getResources(name)) == null || result.isEmpty())) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream result = null;
        if (this.bestCandidate != null && (result = this.bestCandidate.getResourceAsStream(name)) == null) {
            this.bestCandidate = null;
        }
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResourceAsStream(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    public Set<Class<? extends Job>> getJobClasses(String pkgname) {
        HashSet<Class<? extends Job>> classes = new HashSet<Class<? extends Job>>();
        String[] packages = pkgname.split("[\\:,]");
        if (packages.length > 1) {
            for (String pkg : packages) {
                classes.addAll(this.getJobClasses(pkg));
            }
        } else {
            String relPath = pkgname.replace('.', '/').replace("%20", " ");
            List<URL> resources = this.getResources(relPath);
            if (resources.isEmpty()) {
                throw new RuntimeException("Unexpected problem: No resource for " + relPath);
            }
            for (URL resource : resources) {
                String resPath = "";
                try {
                    resPath = URLDecoder.decode(resource.getPath(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                this.logger.info("Package: '" + pkgname + "' becomes Resource: '" + resPath + "'");
                if (resource.toString().startsWith("jar:")) {
                    this.processJarfile(resPath, pkgname, classes);
                    continue;
                }
                this.processDirectory(resPath, pkgname, classes);
            }
        }
        return classes;
    }

    private void processDirectory(String path, String pkgname, Set<Class<? extends Job>> classes) {
        File directory = new File(path);
        this.logger.debug("Reading Directory '" + directory + "'");
        String[] files = directory.list();
        for (int i = 0; i < files.length; ++i) {
            File subdir;
            String fileName = files[i];
            String className = null;
            if (fileName.endsWith(".class")) {
                className = pkgname + '.' + fileName.substring(0, fileName.length() - 6);
            }
            this.logger.debug("FileName '" + fileName + "'  =>  class '" + className + "'");
            if (className != null) {
                this.filterJobClassWithExceptionCatch(className, classes);
            }
            if (!(subdir = new File(directory, fileName)).isDirectory()) continue;
            this.processDirectory(subdir.getPath(), pkgname + '.' + fileName, classes);
        }
    }

    private void processJarfile(String path, String pkgname, Set<Class<? extends Job>> classes) {
        JarFile jarFile;
        String relPath = pkgname.replace('.', '/');
        String jarPath = path.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
        this.logger.debug("Reading JAR file: '" + jarPath + "'");
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException reading JAR File '" + jarPath + "'", e);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            String className = null;
            if (entryName.endsWith(".class") && entryName.startsWith(relPath) && entryName.length() > relPath.length() + "/".length()) {
                className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            }
            this.logger.debug("JarEntry '" + entryName + "'  =>  class '" + className + "'");
            if (className == null) continue;
            this.filterJobClassWithExceptionCatch(className, classes);
        }
    }

    private void filterJobClassWithExceptionCatch(String className, Set<Class<? extends Job>> classes) {
        try {
            Class clazz = this.loadClass(className);
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return;
            }
            if (Modifier.isInterface(clazz.getModifiers())) {
                return;
            }
            if (Job.class.isAssignableFrom(clazz)) {
                classes.add(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected ClassNotFoundException loading class '" + className + "'");
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.bestCandidate == null ? Thread.currentThread().getContextClassLoader() : this.bestCandidate.getClassLoader();
    }
}

