/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.quartz.builders.CronTriggerBuilder;
import org.quartz.builders.JobBuilder;
import org.quartz.builders.SimpleTriggerBuilder;
import org.quartz.classloading.ClassLoadHelper;
import org.quartz.core.Scheduler;
import org.quartz.exceptions.ObjectAlreadyExistsException;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.JobDetail;
import org.quartz.plugins.xml.ValidationException;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSchedulingDataProcessor
implements ErrorHandler {
    private static final String QUARTZ_XSD_PATH_IN_JAR = "org/knowm/sundial/xml/job_scheduling_data.xsd";
    public static final String QUARTZ_XML_DEFAULT_FILE_NAME = "jobs.xml";
    private static final String XSD_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private List<JobDetail> loadedJobs = new LinkedList<JobDetail>();
    private List<OperableTrigger> loadedTriggers = new LinkedList<OperableTrigger>();
    private Collection<Exception> validationExceptions = new ArrayList<Exception>();
    private ClassLoadHelper classLoadHelper = null;
    private DocumentBuilder docBuilder = null;
    private XPath xpath = null;
    private final Logger logger = LoggerFactory.getLogger(XMLSchedulingDataProcessor.class);

    public XMLSchedulingDataProcessor(ClassLoadHelper classLoadHelper) throws ParserConfigurationException {
        this.classLoadHelper = classLoadHelper;
        this.initDocumentParser();
    }

    private void initDocumentParser() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(false);
        docBuilderFactory.setValidating(true);
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.resolveSchemaSource());
        this.docBuilder = docBuilderFactory.newDocumentBuilder();
        this.docBuilder.setErrorHandler(this);
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    private Object resolveSchemaSource() {
        InputSource inputSource = null;
        InputStream is = null;
        is = this.classLoadHelper.getResourceAsStream(QUARTZ_XSD_PATH_IN_JAR);
        if (is == null) {
            this.logger.warn("Could not load jobs schema from classpath!");
        } else {
            inputSource = new InputSource(is);
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile(String fileName, boolean failOnFileNotFound) throws Exception {
        boolean fileFound = false;
        InputStream f = null;
        try {
            String furl = null;
            File file = new File(fileName);
            if (!file.exists()) {
                URL url = this.classLoadHelper.getResource(fileName);
                if (url != null) {
                    try {
                        furl = URLDecoder.decode(url.getPath(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        furl = url.getPath();
                    }
                    file = new File(furl);
                    try {
                        f = url.openStream();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                try {
                    f = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            fileFound = f != null;
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
            }
            catch (IOException ioe) {
                this.logger.warn("Error closing jobs file " + fileName, (Throwable)ioe);
            }
        }
        if (!fileFound) {
            if (failOnFileNotFound) {
                throw new SchedulerException("File named '" + fileName + "' does not exist.");
            }
            this.logger.warn("File named '" + fileName + "' does not exist. This is OK if you don't want to use an XML job config file.");
        } else {
            this.processFile(fileName);
        }
    }

    private void processFile(String fileName) throws ValidationException, ParserConfigurationException, SAXException, IOException, SchedulerException, ClassNotFoundException, ParseException, XPathException {
        this.prepForProcessing();
        this.logger.info("Parsing XML file: " + fileName);
        InputSource is = new InputSource(this.getInputStream(fileName));
        this.process(is);
        this.maybeThrowValidationException();
    }

    private void prepForProcessing() {
        this.clearValidationExceptions();
        this.loadedJobs.clear();
        this.loadedTriggers.clear();
    }

    private void process(InputSource is) throws SAXException, IOException, ParseException, XPathException, ClassNotFoundException {
        Document document = this.docBuilder.parse(is);
        NodeList jobNodes = (NodeList)this.xpath.evaluate("/job-scheduling-data/schedule/job", document, XPathConstants.NODESET);
        this.logger.debug("Found " + jobNodes.getLength() + " job definitions.");
        for (int i = 0; i < jobNodes.getLength(); ++i) {
            Node jobDetailNode = jobNodes.item(i);
            String jobName = this.getTrimmedToNullString(this.xpath, "name", jobDetailNode);
            String jobDescription = this.getTrimmedToNullString(this.xpath, "description", jobDetailNode);
            String jobClassName = this.getTrimmedToNullString(this.xpath, "job-class", jobDetailNode);
            boolean isConcurrencyAllowed = this.getBoolean(this.xpath, "concurrency-allowed", jobDetailNode);
            Class jobClass = this.classLoadHelper.loadClass(jobClassName);
            JobDetail jobDetail = JobBuilder.newJobBuilder(jobClass).withIdentity(jobName).isConcurrencyAllowed(isConcurrencyAllowed).withDescription(jobDescription).build();
            NodeList jobDataEntries = (NodeList)this.xpath.evaluate("job-data-map/entry", jobDetailNode, XPathConstants.NODESET);
            for (int k = 0; k < jobDataEntries.getLength(); ++k) {
                Node entryNode = jobDataEntries.item(k);
                String key = this.getTrimmedToNullString(this.xpath, "key", entryNode);
                String value = this.getTrimmedToNullString(this.xpath, "value", entryNode);
                jobDetail.getJobDataMap().put(key, value);
            }
            this.logger.debug("Parsed job definition: " + jobDetail);
            this.loadedJobs.add(jobDetail);
        }
        NodeList triggerEntries = (NodeList)this.xpath.evaluate("/job-scheduling-data/schedule/trigger/*", document, XPathConstants.NODESET);
        this.logger.debug("Found " + triggerEntries.getLength() + " trigger definitions.");
        for (int j = 0; j < triggerEntries.getLength(); ++j) {
            OperableTrigger trigger;
            Date triggerEndTime;
            Node triggerNode = triggerEntries.item(j);
            String triggerName = this.getTrimmedToNullString(this.xpath, "name", triggerNode);
            String triggerDescription = this.getTrimmedToNullString(this.xpath, "description", triggerNode);
            String triggerMisfireInstructionConst = this.getTrimmedToNullString(this.xpath, "misfire-instruction", triggerNode);
            String triggerPriorityString = this.getTrimmedToNullString(this.xpath, "priority", triggerNode);
            String triggerCalendarRef = this.getTrimmedToNullString(this.xpath, "calendar-name", triggerNode);
            String triggerJobName = this.getTrimmedToNullString(this.xpath, "job-name", triggerNode);
            int triggerPriority = 5;
            if (triggerPriorityString != null) {
                triggerPriority = Integer.valueOf(triggerPriorityString);
            }
            String startTimeString = this.getTrimmedToNullString(this.xpath, "start-time", triggerNode);
            String startTimeFutureSecsString = this.getTrimmedToNullString(this.xpath, "start-time-seconds-in-future", triggerNode);
            String endTimeString = this.getTrimmedToNullString(this.xpath, "end-time", triggerNode);
            Date triggerStartTime = null;
            triggerStartTime = startTimeFutureSecsString != null ? new Date(System.currentTimeMillis() + Long.valueOf(startTimeFutureSecsString) * 1000L) : (startTimeString == null || startTimeString.length() == 0 ? new Date() : dateFormat.parse(startTimeString));
            Date date = triggerEndTime = endTimeString == null || endTimeString.length() == 0 ? null : dateFormat.parse(endTimeString);
            if (triggerNode.getNodeName().equals("simple")) {
                String repeatCountString = this.getTrimmedToNullString(this.xpath, "repeat-count", triggerNode);
                String repeatIntervalString = this.getTrimmedToNullString(this.xpath, "repeat-interval", triggerNode);
                int repeatCount = repeatCountString == null ? -1 : Integer.parseInt(repeatCountString);
                long repeatInterval = repeatIntervalString == null ? 0L : Long.parseLong(repeatIntervalString);
                trigger = SimpleTriggerBuilder.simpleTriggerBuilder().withRepeatCount(repeatCount).withIntervalInMilliseconds(repeatInterval).withIdentity(triggerName).withDescription(triggerDescription).forJob(triggerJobName).startAt(triggerStartTime).endAt(triggerEndTime).withPriority(triggerPriority).modifiedByCalendar(triggerCalendarRef).build();
                if (triggerMisfireInstructionConst != null && triggerMisfireInstructionConst.length() != 0) {
                    if (triggerMisfireInstructionConst.equals("MISFIRE_INSTRUCTION_FIRE_NOW")) {
                        ((SimpleTriggerBuilder)((Object)trigger)).withMisfireHandlingInstructionFireNow();
                    } else if (triggerMisfireInstructionConst.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT")) {
                        ((SimpleTriggerBuilder)((Object)trigger)).withMisfireHandlingInstructionNextWithExistingCount();
                    } else if (triggerMisfireInstructionConst.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT")) {
                        ((SimpleTriggerBuilder)((Object)trigger)).withMisfireHandlingInstructionNextWithRemainingCount();
                    } else if (triggerMisfireInstructionConst.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT")) {
                        ((SimpleTriggerBuilder)((Object)trigger)).withMisfireHandlingInstructionNowWithExistingCount();
                    } else if (triggerMisfireInstructionConst.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT")) {
                        ((SimpleTriggerBuilder)((Object)trigger)).withMisfireHandlingInstructionNowWithRemainingCount();
                    } else if (!triggerMisfireInstructionConst.equals("MISFIRE_INSTRUCTION_SMART_POLICY")) {
                        throw new ParseException("Unexpected/Unhandlable Misfire Instruction encountered '" + triggerMisfireInstructionConst + "', for trigger: " + triggerName, -1);
                    }
                }
            } else if (triggerNode.getNodeName().equals("cron")) {
                String cronExpression = this.getTrimmedToNullString(this.xpath, "cron-expression", triggerNode);
                String timezoneString = this.getTrimmedToNullString(this.xpath, "time-zone", triggerNode);
                TimeZone tz = timezoneString == null ? null : TimeZone.getTimeZone(timezoneString);
                trigger = CronTriggerBuilder.cronTriggerBuilder(cronExpression).inTimeZone(tz).withIdentity(triggerName).withDescription(triggerDescription).forJob(triggerJobName).startAt(triggerStartTime).endAt(triggerEndTime).withPriority(triggerPriority).modifiedByCalendar(triggerCalendarRef).build();
                if (triggerMisfireInstructionConst != null && triggerMisfireInstructionConst.length() != 0) {
                    if (triggerMisfireInstructionConst.equals("MISFIRE_INSTRUCTION_DO_NOTHING")) {
                        ((CronTriggerBuilder)((Object)trigger)).withMisfireHandlingInstructionDoNothing();
                    } else if (triggerMisfireInstructionConst.equals("MISFIRE_INSTRUCTION_FIRE_ONCE_NOW")) {
                        ((CronTriggerBuilder)((Object)trigger)).withMisfireHandlingInstructionFireAndProceed();
                    } else if (!triggerMisfireInstructionConst.equals("MISFIRE_INSTRUCTION_SMART_POLICY")) {
                        throw new ParseException("Unexpected/Unhandlable Misfire Instruction encountered '" + triggerMisfireInstructionConst + "', for trigger: " + triggerName, -1);
                    }
                }
            } else {
                throw new ParseException("Unknown trigger type: " + triggerNode.getNodeName(), -1);
            }
            NodeList jobDataEntries = (NodeList)this.xpath.evaluate("job-data-map/entry", triggerNode, XPathConstants.NODESET);
            for (int k = 0; k < jobDataEntries.getLength(); ++k) {
                Node entryNode = jobDataEntries.item(k);
                String key = this.getTrimmedToNullString(this.xpath, "key", entryNode);
                String value = this.getTrimmedToNullString(this.xpath, "value", entryNode);
                trigger.getJobDataMap().put(key, value);
            }
            this.logger.debug("Parsed trigger definition: " + trigger);
            this.loadedTriggers.add(trigger);
        }
    }

    private String getTrimmedToNullString(XPath xpath, String elementName, Node parentNode) throws XPathExpressionException {
        String str = (String)xpath.evaluate(elementName, parentNode, XPathConstants.STRING);
        if (str != null) {
            str = str.trim();
        }
        if (str != null && str.length() == 0) {
            str = null;
        }
        return str;
    }

    protected Boolean getBoolean(XPath xpathToElement, String elementName, Node parentNode) throws XPathExpressionException {
        String str = (String)this.xpath.evaluate(elementName, parentNode, XPathConstants.STRING);
        return str.equalsIgnoreCase("true");
    }

    private List<JobDetail> getLoadedJobs() {
        return Collections.unmodifiableList(this.loadedJobs);
    }

    private List<OperableTrigger> getLoadedTriggers() {
        return Collections.unmodifiableList(this.loadedTriggers);
    }

    private InputStream getInputStream(String fileName) {
        return this.classLoadHelper.getResourceAsStream(fileName);
    }

    public void scheduleJobs(Scheduler sched) throws SchedulerException {
        LinkedList<JobDetail> jobs = new LinkedList<JobDetail>(this.getLoadedJobs());
        LinkedList<OperableTrigger> triggers = new LinkedList<OperableTrigger>(this.getLoadedTriggers());
        this.logger.info("Adding " + jobs.size() + " jobs, " + triggers.size() + " triggers.");
        for (JobDetail jobDetail : jobs) {
            this.logger.info("Scheduled job: {} ", (Object)jobDetail);
            sched.addJob(jobDetail);
        }
        for (OperableTrigger trigger : triggers) {
            Trigger dupeT;
            this.logger.info("Scheduled trigger: {}", (Object)trigger);
            if (trigger.getStartTime() == null) {
                trigger.setStartTime(new Date());
            }
            if ((dupeT = sched.getTrigger(trigger.getName())) != null) {
                if (!dupeT.getJobName().equals(trigger.getJobName())) {
                    this.logger.warn("Possibly duplicately named ({}) triggers in jobs xml file! ", (Object)trigger.getName());
                }
                sched.rescheduleJob(trigger.getName(), trigger);
                continue;
            }
            this.logger.debug("Scheduling job: " + trigger.getJobName() + " with trigger: " + trigger.getName());
            try {
                sched.scheduleJob(trigger);
            }
            catch (ObjectAlreadyExistsException e) {
                this.logger.debug("Adding trigger: " + trigger.getName() + " for job: " + trigger.getJobName() + " failed because the trigger already existed.");
            }
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.addValidationException(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.addValidationException(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.addValidationException(e);
    }

    private void addValidationException(SAXException e) {
        this.validationExceptions.add(e);
    }

    private void clearValidationExceptions() {
        this.validationExceptions.clear();
    }

    private void maybeThrowValidationException() throws ValidationException {
        if (this.validationExceptions.size() > 0) {
            throw new ValidationException("Encountered " + this.validationExceptions.size() + " validation exceptions.", this.validationExceptions);
        }
    }
}

