/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.sundial;

import java.util.HashMap;
import java.util.Map;
import org.knowm.sundial.exceptions.RequiredParameterException;
import org.quartz.core.JobExecutionContext;
import org.quartz.triggers.CronTrigger;

public class JobContext {
    private static final String KEY_JOB_NAME = "KEY_JOB_NAME";
    private static final String KEY_TRIGGER_NAME = "KEY_TRIGGER_NAME";
    private static final String KEY_TRIGGER_CRON_EXPRESSION = "KEY_TRIGGER_CRON_EXPRESSION";
    public Map<String, Object> map = new HashMap<String, Object>();

    public void addQuartzContext(JobExecutionContext jobExecutionContext) {
        for (Object mapKey : jobExecutionContext.getMergedJobDataMap().keySet()) {
            this.map.put((String)mapKey, jobExecutionContext.getMergedJobDataMap().get(mapKey));
        }
        this.map.put(KEY_JOB_NAME, jobExecutionContext.getJobDetail().getName());
        this.map.put(KEY_TRIGGER_NAME, jobExecutionContext.getTrigger().getName());
        if (jobExecutionContext.getTrigger() instanceof CronTrigger) {
            this.map.put(KEY_TRIGGER_CRON_EXPRESSION, ((CronTrigger)jobExecutionContext.getTrigger()).getCronExpression());
        }
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public <T> T get(String key) {
        Object value = this.map.get(key);
        return (T)value;
    }

    public <T> T getRequiredValue(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            throw new RequiredParameterException();
        }
        return (T)value;
    }

    public String getJobName() {
        return (String)this.get(KEY_JOB_NAME);
    }

    public String getTriggerName() {
        return (String)this.get(KEY_TRIGGER_NAME);
    }

    public String getCronExpressionName() {
        return (String)this.get(KEY_TRIGGER_CRON_EXPRESSION);
    }
}

