/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.sundial.ee;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.knowm.sundial.SundialJobScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SundialInitializerListener
implements ServletContextListener {
    private boolean performShutdown = true;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.logger.info("Sundial Initializer Servlet loaded, initializing Scheduler...");
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            String shutdownPrefString = servletContext.getInitParameter("shutdown-on-unload");
            if (shutdownPrefString != null) {
                this.performShutdown = Boolean.valueOf(shutdownPrefString);
            }
            int threadPoolSize = 10;
            String threadPoolSizeString = servletContext.getInitParameter("thread-pool-size");
            try {
                if (threadPoolSizeString != null && threadPoolSizeString.trim().length() > 0) {
                    threadPoolSize = Integer.parseInt(threadPoolSizeString);
                }
            }
            catch (Exception e) {
                this.logger.error("Cannot parse value of 'thread-pool-size' to an integer: " + threadPoolSizeString + ", defaulting to 10 threads.");
            }
            String packageName = servletContext.getInitParameter("annotated-jobs-package-name");
            SundialJobScheduler.createScheduler(threadPoolSize, packageName);
            SundialJobScheduler.setServletContext(servletContext);
            String startOnLoadString = servletContext.getInitParameter("start-scheduler-on-load");
            int startDelay = 0;
            String startDelayString = servletContext.getInitParameter("start-delay-seconds");
            try {
                if (startDelayString != null && startDelayString.trim().length() > 0) {
                    startDelay = Integer.parseInt(startDelayString);
                }
            }
            catch (Exception e) {
                this.logger.error("Cannot parse value of 'start-delay-seconds' to an integer: " + startDelayString + ", defaulting to 5 seconds.");
                startDelay = 5;
            }
            if (startOnLoadString == null || Boolean.valueOf(startOnLoadString).booleanValue()) {
                if (startDelay <= 0) {
                    SundialJobScheduler.getScheduler().start();
                    this.logger.info("Sundial Scheduler has been started...");
                } else {
                    SundialJobScheduler.getScheduler().startDelayed(startDelay);
                    this.logger.info("Sundial Scheduler will start in " + startDelay + " seconds.");
                }
            } else {
                this.logger.info("Sundial Scheduler has not been started. Use scheduler.start()");
            }
            String globalLockOnLoadString = servletContext.getInitParameter("global-lock-on-load");
            boolean globalLockOnLoad = false;
            if (globalLockOnLoadString != null && (globalLockOnLoad = Boolean.valueOf(globalLockOnLoadString).booleanValue())) {
                SundialJobScheduler.lockScheduler();
                this.logger.info("Sundial Scheduler has been locked.");
            }
        }
        catch (Exception e) {
            this.logger.error("Sundial Scheduler failed to initialize: ", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (!this.performShutdown) {
            return;
        }
        try {
            if (SundialJobScheduler.getScheduler() != null) {
                SundialJobScheduler.getScheduler().shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error("Sundial Scheduler failed to shutdown cleanly: ", (Throwable)e);
        }
        this.logger.info("Sundial Scheduler successful shutdown.");
    }
}

