/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.quartz.ErrorLoggingScheduleListener;
import org.quartz.ExecutingJobsManager;
import org.quartz.builders.SimpleTriggerBuilder;
import org.quartz.classloading.CascadingClassLoadHelper;
import org.quartz.core.Calendar;
import org.quartz.core.JobExecutionContext;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.core.Scheduler;
import org.quartz.core.SchedulerSignaler;
import org.quartz.core.SchedulerSignalerImpl;
import org.quartz.exceptions.JobExecutionException;
import org.quartz.exceptions.JobPersistenceException;
import org.quartz.exceptions.ObjectAlreadyExistsException;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.InterruptableJob;
import org.quartz.jobs.JobDataMap;
import org.quartz.jobs.JobDetail;
import org.quartz.jobs.JobFactory;
import org.quartz.jobs.SimpleJobFactory;
import org.quartz.listeners.JobListener;
import org.quartz.listeners.ListenerManager;
import org.quartz.listeners.ListenerManagerImpl;
import org.quartz.listeners.SchedulerListener;
import org.quartz.listeners.TriggerListener;
import org.quartz.plugins.SchedulerPlugin;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzScheduler
implements Scheduler {
    private final QuartzSchedulerResources quartzSchedulerResources;
    private final QuartzSchedulerThread quartzSchedulerThread;
    private ThreadGroup threadGroup;
    private final ListenerManager listenerManager = new ListenerManagerImpl();
    private final Map<String, JobListener> internalJobListeners = new HashMap<String, JobListener>(10);
    private final Map<String, TriggerListener> internalTriggerListeners = new HashMap<String, TriggerListener>(10);
    private final List<SchedulerListener> internalSchedulerListeners = new ArrayList<SchedulerListener>(10);
    private JobFactory jobFactory = new SimpleJobFactory();
    private ExecutingJobsManager jobMgr = null;
    private ErrorLoggingScheduleListener errLogger = null;
    private final SchedulerSignaler signaler;
    private final Random random = new Random();
    private boolean signalOnSchedulingChange = true;
    private volatile boolean closed = false;
    private volatile boolean shuttingDown = false;
    private Date initialStart = null;
    CascadingClassLoadHelper cascadingClassLoadHelper = new CascadingClassLoadHelper();
    private final Logger logger = LoggerFactory.getLogger(QuartzScheduler.class);

    public QuartzScheduler(QuartzSchedulerResources quartzSchedulerResources) throws SchedulerException {
        this.quartzSchedulerResources = quartzSchedulerResources;
        if (quartzSchedulerResources.getJobStore() instanceof JobListener) {
            this.addInternalJobListener((JobListener)((Object)quartzSchedulerResources.getJobStore()));
        }
        this.quartzSchedulerThread = new QuartzSchedulerThread(this, quartzSchedulerResources);
        this.jobMgr = new ExecutingJobsManager();
        this.addInternalJobListener(this.jobMgr);
        this.errLogger = new ErrorLoggingScheduleListener();
        this.addInternalSchedulerListener(this.errLogger);
        this.signaler = new SchedulerSignalerImpl(this, this.quartzSchedulerThread);
        this.cascadingClassLoadHelper.initialize();
    }

    public void initialize() throws SchedulerException {
        this.quartzSchedulerThread.start();
    }

    public SchedulerSignaler getSchedulerSignaler() {
        return this.signaler;
    }

    public ThreadGroup getSchedulerThreadGroup() {
        if (this.threadGroup == null) {
            this.threadGroup = new ThreadGroup("QuartzScheduler");
            if (this.quartzSchedulerResources.getMakeSchedulerThreadDaemon()) {
                this.threadGroup.setDaemon(true);
            }
        }
        return this.threadGroup;
    }

    public boolean isSignalOnSchedulingChange() {
        return this.signalOnSchedulingChange;
    }

    public void setSignalOnSchedulingChange(boolean signalOnSchedulingChange) {
        this.signalOnSchedulingChange = signalOnSchedulingChange;
    }

    @Override
    public void start() throws SchedulerException {
        if (this.shuttingDown || this.closed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        if (this.initialStart == null) {
            this.initialStart = new Date();
            this.quartzSchedulerResources.getJobStore().schedulerStarted();
            this.startPlugins();
        }
        this.quartzSchedulerThread.togglePause(false);
        this.logger.info("Scheduler started.");
        this.notifySchedulerListenersStarted();
    }

    @Override
    public void startDelayed(final int seconds) throws SchedulerException {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep((long)seconds * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    QuartzScheduler.this.start();
                }
                catch (SchedulerException se) {
                    QuartzScheduler.this.logger.error("Unable to start secheduler after startup delay.", (Throwable)se);
                }
            }
        });
        t.start();
    }

    @Override
    public void standby() {
        this.quartzSchedulerThread.togglePause(true);
        this.logger.info("Scheduler paused.");
        this.notifySchedulerListenersInStandbyMode();
    }

    @Override
    public boolean isInStandbyMode() {
        return this.quartzSchedulerThread.isPaused();
    }

    public Class getJobStoreClass() {
        return this.quartzSchedulerResources.getJobStore().getClass();
    }

    public Class getThreadPoolClass() {
        return this.quartzSchedulerResources.getThreadPool().getClass();
    }

    public int getThreadPoolSize() {
        return this.quartzSchedulerResources.getThreadPool().getPoolSize();
    }

    @Override
    public void shutdown() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.shuttingDown || this.closed) {
            return;
        }
        this.shuttingDown = true;
        this.logger.info("Scheduler shutting down...");
        this.standby();
        this.quartzSchedulerThread.halt();
        this.notifySchedulerListenersShuttingdown();
        List<JobExecutionContext> jobs = this.getCurrentlyExecutingJobs();
        for (JobExecutionContext job : jobs) {
            if (!(job.getJobInstance() instanceof InterruptableJob)) continue;
            try {
                ((InterruptableJob)job.getJobInstance()).interrupt();
            }
            catch (Throwable e) {
                this.logger.warn("Encountered error when interrupting job {} during shutdown: {}", (Object)job.getJobDetail().getName(), (Object)e);
            }
        }
        this.logger.info("Threadpool shutting down...");
        this.quartzSchedulerResources.getThreadPool().shutdown();
        try {
            this.quartzSchedulerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.closed = true;
        this.shutdownPlugins();
        this.notifySchedulerListenersShutdown();
        this.logger.info("Scheduler shutdown complete.");
    }

    @Override
    public boolean isShutdown() {
        return this.closed;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    @Override
    public boolean isStarted() {
        return !this.shuttingDown && !this.closed && !this.isInStandbyMode() && this.initialStart != null;
    }

    private void validateState() throws SchedulerException {
        if (this.isShutdown()) {
            throw new SchedulerException("The Scheduler has been shutdown.");
        }
    }

    @Override
    public List<JobExecutionContext> getCurrentlyExecutingJobs() {
        return this.jobMgr.getExecutingJobs();
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, OperableTrigger trigger) throws SchedulerException {
        this.validateState();
        if (jobDetail == null) {
            throw new SchedulerException("JobDetail cannot be null");
        }
        if (trigger == null) {
            throw new SchedulerException("Trigger cannot be null");
        }
        if (jobDetail.getName() == null) {
            throw new SchedulerException("Job's key cannot be null");
        }
        if (jobDetail.getJobClass() == null) {
            throw new SchedulerException("Job's class cannot be null");
        }
        OperableTrigger trig = trigger;
        if (trigger.getJobName() == null) {
            trig.setJobName(jobDetail.getName());
        } else if (!trigger.getJobName().equals(jobDetail.getName())) {
            throw new SchedulerException("Trigger does not reference given job!");
        }
        trig.validate();
        Calendar cal = null;
        if (trigger.getCalendarName() != null && (cal = this.quartzSchedulerResources.getJobStore().retrieveCalendar(trigger.getCalendarName())) == null) {
            throw new SchedulerException("Calendar not found: " + trigger.getCalendarName());
        }
        Date ft = trig.computeFirstFireTime(cal);
        if (ft == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.");
        }
        this.quartzSchedulerResources.getJobStore().storeJobAndTrigger(jobDetail, trig);
        this.notifySchedulerListenersJobAdded(jobDetail);
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersScheduled(trigger);
        return ft;
    }

    @Override
    public Date scheduleJob(OperableTrigger trigger) throws SchedulerException {
        this.validateState();
        if (trigger == null) {
            throw new SchedulerException("Trigger cannot be null");
        }
        OperableTrigger trig = trigger;
        trig.validate();
        Calendar cal = null;
        if (trigger.getCalendarName() != null && (cal = this.quartzSchedulerResources.getJobStore().retrieveCalendar(trigger.getCalendarName())) == null) {
            throw new SchedulerException("Calendar not found: " + trigger.getCalendarName());
        }
        Date ft = trig.computeFirstFireTime(cal);
        if (ft == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.");
        }
        this.quartzSchedulerResources.getJobStore().storeTrigger(trig, false);
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersScheduled(trigger);
        return ft;
    }

    @Override
    public void addJob(JobDetail jobDetail) throws SchedulerException {
        this.validateState();
        this.quartzSchedulerResources.getJobStore().storeJob(jobDetail, true);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersJobAdded(jobDetail);
    }

    @Override
    public void deleteJob(String jobKey) throws SchedulerException {
        this.validateState();
        List<Trigger> triggers = this.getTriggersOfJob(jobKey);
        for (Trigger trigger : triggers) {
            this.unscheduleJob(trigger.getName());
        }
        boolean result = this.quartzSchedulerResources.getJobStore().removeJob(jobKey);
        if (result) {
            this.notifySchedulerThread(0L);
            this.notifySchedulerListenersJobDeleted(jobKey);
        }
    }

    @Override
    public void unscheduleJob(String triggerKey) throws SchedulerException {
        this.validateState();
        if (this.quartzSchedulerResources.getJobStore().removeTrigger(triggerKey)) {
            this.notifySchedulerThread(0L);
            this.notifySchedulerListenersUnscheduled(triggerKey);
        }
    }

    @Override
    public Date rescheduleJob(String triggerName, OperableTrigger newTrigger) throws SchedulerException {
        Date ft;
        this.validateState();
        if (triggerName == null) {
            throw new IllegalArgumentException("triggerKey cannot be null");
        }
        if (newTrigger == null) {
            throw new IllegalArgumentException("newTrigger cannot be null");
        }
        OperableTrigger trig = newTrigger;
        Trigger oldTrigger = this.getTrigger(triggerName);
        if (oldTrigger == null) {
            return null;
        }
        trig.setJobName(oldTrigger.getJobName());
        trig.validate();
        Calendar cal = null;
        if (newTrigger.getCalendarName() != null) {
            cal = this.quartzSchedulerResources.getJobStore().retrieveCalendar(newTrigger.getCalendarName());
        }
        if ((ft = trig.computeFirstFireTime(cal)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.");
        }
        if (!this.quartzSchedulerResources.getJobStore().replaceTrigger(triggerName, trig)) {
            return null;
        }
        this.notifySchedulerThread(newTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersUnscheduled(triggerName);
        this.notifySchedulerListenersScheduled(newTrigger);
        return ft;
    }

    private String newTriggerId() {
        long r = this.random.nextLong();
        if (r < 0L) {
            r = -r;
        }
        return "MT_" + Long.toString(r, 30 + (int)(System.currentTimeMillis() % 7L));
    }

    @Override
    public void triggerJob(String jobKey, JobDataMap data) throws SchedulerException {
        this.validateState();
        OperableTrigger operableTrigger = SimpleTriggerBuilder.simpleTriggerBuilder().withIdentity(jobKey + "-trigger").forJob(jobKey).startAt(new Date()).build();
        operableTrigger.computeFirstFireTime(null);
        if (data != null) {
            operableTrigger.setJobDataMap(data);
        }
        boolean collision = true;
        while (collision) {
            try {
                this.quartzSchedulerResources.getJobStore().storeTrigger(operableTrigger, false);
                collision = false;
            }
            catch (ObjectAlreadyExistsException oaee) {
                operableTrigger.setName(this.newTriggerId());
            }
        }
        this.notifySchedulerThread(operableTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersScheduled(operableTrigger);
    }

    @Override
    public List<Trigger> getTriggersOfJob(String jobKey) throws SchedulerException {
        this.validateState();
        return this.quartzSchedulerResources.getJobStore().getTriggersForJob(jobKey);
    }

    @Override
    public JobDetail getJobDetail(String jobKey) throws SchedulerException {
        this.validateState();
        return this.quartzSchedulerResources.getJobStore().retrieveJob(jobKey);
    }

    @Override
    public Trigger getTrigger(String triggerKey) throws SchedulerException {
        this.validateState();
        return this.quartzSchedulerResources.getJobStore().retrieveTrigger(triggerKey);
    }

    @Override
    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInternalJobListener(JobListener jobListener) {
        if (jobListener.getName() == null || jobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        Map<String, JobListener> map = this.internalJobListeners;
        synchronized (map) {
            this.internalJobListeners.put(jobListener.getName(), jobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobListener> getInternalJobListeners() {
        Map<String, JobListener> map = this.internalJobListeners;
        synchronized (map) {
            return Collections.unmodifiableList(new LinkedList<JobListener>(this.internalJobListeners.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TriggerListener> getInternalTriggerListeners() {
        Map<String, TriggerListener> map = this.internalTriggerListeners;
        synchronized (map) {
            return Collections.unmodifiableList(new LinkedList<TriggerListener>(this.internalTriggerListeners.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalSchedulerListener(SchedulerListener schedulerListener) {
        List<SchedulerListener> list = this.internalSchedulerListeners;
        synchronized (list) {
            this.internalSchedulerListeners.add(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInternalSchedulerListener(SchedulerListener schedulerListener) {
        List<SchedulerListener> list = this.internalSchedulerListeners;
        synchronized (list) {
            return this.internalSchedulerListeners.remove(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SchedulerListener> getInternalSchedulerListeners() {
        List<SchedulerListener> list = this.internalSchedulerListeners;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<SchedulerListener>(this.internalSchedulerListeners));
        }
    }

    public void notifyJobStoreJobComplete(OperableTrigger trigger, JobDetail detail, Trigger.CompletedExecutionInstruction instCode) throws JobPersistenceException {
        this.quartzSchedulerResources.getJobStore().triggeredJobComplete(trigger, detail, instCode);
    }

    public void notifyJobStoreJobVetoed(OperableTrigger trigger, JobDetail detail, Trigger.CompletedExecutionInstruction instCode) throws JobPersistenceException {
        this.quartzSchedulerResources.getJobStore().triggeredJobComplete(trigger, detail, instCode);
    }

    private void notifySchedulerThread(long candidateNewNextFireTime) {
        if (this.isSignalOnSchedulingChange()) {
            this.signaler.signalSchedulingChange(candidateNewNextFireTime);
        }
    }

    private List<TriggerListener> buildTriggerListenerList() throws SchedulerException {
        LinkedList<TriggerListener> allListeners = new LinkedList<TriggerListener>();
        allListeners.addAll(this.getListenerManager().getTriggerListeners());
        allListeners.addAll(this.getInternalTriggerListeners());
        return allListeners;
    }

    private List<JobListener> buildJobListenerList() throws SchedulerException {
        LinkedList<JobListener> allListeners = new LinkedList<JobListener>();
        allListeners.addAll(this.getListenerManager().getJobListeners());
        allListeners.addAll(this.getInternalJobListeners());
        return allListeners;
    }

    private List<SchedulerListener> buildSchedulerListenerList() {
        LinkedList<SchedulerListener> allListeners = new LinkedList<SchedulerListener>();
        allListeners.addAll(this.getListenerManager().getSchedulerListeners());
        allListeners.addAll(this.getInternalSchedulerListeners());
        return allListeners;
    }

    public boolean notifyTriggerListenersFired(JobExecutionContext jec) throws SchedulerException {
        boolean vetoedExecution = false;
        List<TriggerListener> triggerListeners = this.buildTriggerListenerList();
        for (TriggerListener tl : triggerListeners) {
            try {
                tl.triggerFired(jec.getTrigger(), jec);
                if (!tl.vetoJobExecution(jec.getTrigger(), jec)) continue;
                vetoedExecution = true;
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("TriggerListener '" + tl.getName() + "' threw exception: " + e.getMessage(), e);
                throw se;
            }
        }
        return vetoedExecution;
    }

    public void notifyTriggerListenersMisfired(Trigger trigger) throws SchedulerException {
        List<TriggerListener> triggerListeners = this.buildTriggerListenerList();
        for (TriggerListener tl : triggerListeners) {
            try {
                tl.triggerMisfired(trigger);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("TriggerListener '" + tl.getName() + "' threw exception: " + e.getMessage(), e);
                throw se;
            }
        }
    }

    public void notifyTriggerListenersComplete(JobExecutionContext jec, Trigger.CompletedExecutionInstruction instCode) throws SchedulerException {
        List<TriggerListener> triggerListeners = this.buildTriggerListenerList();
        for (TriggerListener tl : triggerListeners) {
            try {
                tl.triggerComplete(jec.getTrigger(), jec, instCode);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("TriggerListener '" + tl.getName() + "' threw exception: " + e.getMessage(), e);
                throw se;
            }
        }
    }

    public void notifyJobListenersToBeExecuted(JobExecutionContext jec) throws SchedulerException {
        List<JobListener> jobListeners = this.buildJobListenerList();
        for (JobListener jl : jobListeners) {
            try {
                jl.jobToBeExecuted(jec);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("JobListener '" + jl.getName() + "' threw exception: " + e.getMessage(), e);
                throw se;
            }
        }
    }

    public void notifyJobListenersWasVetoed(JobExecutionContext jec) throws SchedulerException {
        List<JobListener> jobListeners = this.buildJobListenerList();
        for (JobListener jl : jobListeners) {
            try {
                jl.jobExecutionVetoed(jec);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("JobListener '" + jl.getName() + "' threw exception: " + e.getMessage(), e);
                throw se;
            }
        }
    }

    public void notifyJobListenersWasExecuted(JobExecutionContext jec, JobExecutionException je) throws SchedulerException {
        List<JobListener> jobListeners = this.buildJobListenerList();
        for (JobListener jl : jobListeners) {
            try {
                jl.jobWasExecuted(jec, je);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("JobListener '" + jl.getName() + "' threw exception: " + e.getMessage(), e);
                throw se;
            }
        }
    }

    public void notifySchedulerListenersError(String msg, SchedulerException se) {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.schedulerError(msg, se);
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of error: ", (Throwable)e);
                this.logger.error("  Original error (for notification) was: " + msg, (Throwable)se);
            }
        }
    }

    private void notifySchedulerListenersScheduled(Trigger trigger) {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.jobScheduled(trigger);
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of scheduled job.  Triger=" + trigger.getName(), (Throwable)e);
            }
        }
    }

    private void notifySchedulerListenersUnscheduled(String triggerKey) {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                if (triggerKey == null) {
                    sl.schedulingDataCleared();
                    continue;
                }
                sl.jobUnscheduled(triggerKey);
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of unscheduled job.  Triger=" + (triggerKey == null ? "ALL DATA" : triggerKey), (Throwable)e);
            }
        }
    }

    public void notifySchedulerListenersFinalized(Trigger trigger) {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.triggerFinalized(trigger);
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of finalized trigger.  Triger=" + trigger.getName(), (Throwable)e);
            }
        }
    }

    private void notifySchedulerListenersInStandbyMode() {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.schedulerInStandbyMode();
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of inStandByMode.", (Throwable)e);
            }
        }
    }

    private void notifySchedulerListenersStarted() {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.schedulerStarted();
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of startup.", (Throwable)e);
            }
        }
    }

    private void notifySchedulerListenersShutdown() {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.schedulerShutdown();
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of shutdown.", (Throwable)e);
            }
        }
    }

    private void notifySchedulerListenersShuttingdown() {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.schedulerShuttingdown();
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of shutdown.", (Throwable)e);
            }
        }
    }

    private void notifySchedulerListenersJobAdded(JobDetail jobDetail) {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.jobAdded(jobDetail);
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of Job Added.", (Throwable)e);
            }
        }
    }

    public void notifySchedulerListenersJobDeleted(String jobKey) {
        List<SchedulerListener> schedListeners = this.buildSchedulerListenerList();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.jobDeleted(jobKey);
            }
            catch (Exception e) {
                this.logger.error("Error while notifying SchedulerListener of Job Deleted.", (Throwable)e);
            }
        }
    }

    @Override
    public void setJobFactory(JobFactory factory) throws SchedulerException {
        if (factory == null) {
            throw new IllegalArgumentException("JobFactory cannot be set to null!");
        }
        this.logger.info("JobFactory set to: " + factory);
        this.jobFactory = factory;
    }

    public JobFactory getJobFactory() {
        return this.jobFactory;
    }

    private void shutdownPlugins() {
        for (SchedulerPlugin plugin : this.quartzSchedulerResources.getSchedulerPlugins()) {
            plugin.shutdown();
        }
    }

    private void startPlugins() {
        for (SchedulerPlugin plugin : this.quartzSchedulerResources.getSchedulerPlugins()) {
            plugin.start();
        }
    }

    @Override
    public CascadingClassLoadHelper getCascadingClassLoadHelper() {
        return this.cascadingClassLoadHelper;
    }

    @Override
    public Set<String> getJobKeys() throws SchedulerException {
        this.validateState();
        return this.quartzSchedulerResources.getJobStore().getJobKeys();
    }
}

