/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.builders;

import java.util.Date;
import java.util.UUID;
import org.quartz.jobs.JobDataMap;
import org.quartz.triggers.OperableTrigger;

public abstract class TriggerBuilder {
    private String name;
    private String description;
    private Date startTime = new Date();
    private Date endTime;
    private int priority = 5;
    private String calendarName;
    private String jobName;
    private JobDataMap jobDataMap = new JobDataMap();
    private OperableTrigger operableTrigger = null;

    public abstract OperableTrigger instantiate();

    public OperableTrigger build() {
        this.operableTrigger = this.instantiate();
        this.operableTrigger.setCalendarName(this.calendarName);
        this.operableTrigger.setDescription(this.description);
        this.operableTrigger.setEndTime(this.endTime);
        if (this.name == null) {
            this.name = UUID.randomUUID().toString();
        }
        this.operableTrigger.setName(this.name);
        if (this.jobName != null) {
            this.operableTrigger.setJobName(this.jobName);
        }
        this.operableTrigger.setPriority(this.priority);
        this.operableTrigger.setStartTime(this.startTime);
        if (!this.jobDataMap.isEmpty()) {
            this.operableTrigger.setJobDataMap(this.jobDataMap);
        }
        return this.operableTrigger;
    }

    public TriggerBuilder withIdentity(String name) {
        this.name = name;
        return this;
    }

    public TriggerBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public TriggerBuilder withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public TriggerBuilder modifiedByCalendar(String calendarName) {
        this.calendarName = calendarName;
        return this;
    }

    public TriggerBuilder startNow() {
        this.startTime = new Date();
        return this;
    }

    public TriggerBuilder startAt(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public TriggerBuilder endAt(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public TriggerBuilder withTriggerImplementation(OperableTrigger operableTrigger) {
        this.operableTrigger = operableTrigger;
        return this;
    }

    public TriggerBuilder forJob(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public TriggerBuilder usingJobData(JobDataMap newJobDataMap) {
        this.jobDataMap = newJobDataMap;
        return this;
    }
}

