/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.io.Serializable;
import java.util.Date;
import org.quartz.core.Calendar;
import org.quartz.core.JobExecutionContext;
import org.quartz.core.Scheduler;
import org.quartz.core.TriggerFiredBundle;
import org.quartz.jobs.Job;
import org.quartz.jobs.JobDataMap;
import org.quartz.jobs.JobDetail;
import org.quartz.triggers.Trigger;

public class JobExecutionContextImpl
implements Serializable,
JobExecutionContext {
    private transient Scheduler scheduler;
    private Trigger trigger;
    private JobDetail jobDetail;
    private JobDataMap jobDataMap;
    private transient Job job;
    private Calendar calendar;
    private boolean recovering = false;
    private int numRefires = 0;
    private Date fireTime;
    private Date scheduledFireTime;
    private Date prevFireTime;
    private Date nextFireTime;
    private long jobRunTime = -1L;
    private Object result;

    public JobExecutionContextImpl(Scheduler scheduler, TriggerFiredBundle firedBundle, Job job) {
        this.scheduler = scheduler;
        this.trigger = firedBundle.getTrigger();
        this.calendar = firedBundle.getCalendar();
        this.jobDetail = firedBundle.getJobDetail();
        this.job = job;
        this.recovering = firedBundle.isRecovering();
        this.fireTime = firedBundle.getFireTime();
        this.scheduledFireTime = firedBundle.getScheduledFireTime();
        this.prevFireTime = firedBundle.getPrevFireTime();
        this.nextFireTime = firedBundle.getNextFireTime();
        this.jobDataMap = new JobDataMap();
        this.jobDataMap.putAll(this.jobDetail.getJobDataMap());
        this.jobDataMap.putAll(this.trigger.getJobDataMap());
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public Trigger getTrigger() {
        return this.trigger;
    }

    @Override
    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public boolean isRecovering() {
        return this.recovering;
    }

    public void incrementRefireCount() {
        ++this.numRefires;
    }

    @Override
    public int getRefireCount() {
        return this.numRefires;
    }

    @Override
    public JobDataMap getMergedJobDataMap() {
        return this.jobDataMap;
    }

    @Override
    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    @Override
    public Job getJobInstance() {
        return this.job;
    }

    @Override
    public Date getFireTime() {
        return this.fireTime;
    }

    @Override
    public Date getScheduledFireTime() {
        return this.scheduledFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.prevFireTime;
    }

    @Override
    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public String toString() {
        return "JobExecutionContext: trigger: '" + this.getTrigger().getName() + " job: " + this.getJobDetail().getName() + " fireTime: '" + this.getFireTime() + " scheduledFireTime: " + this.getScheduledFireTime() + " previousFireTime: '" + this.getPreviousFireTime() + " nextFireTime: " + this.getNextFireTime() + " isRecovering: " + this.isRecovering() + " refireCount: " + this.getRefireCount();
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public long getJobRunTime() {
        return this.jobRunTime;
    }

    public void setJobRunTime(long jobRunTime) {
        this.jobRunTime = jobRunTime;
    }
}

