/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.List;
import java.util.Set;
import org.quartz.core.Calendar;
import org.quartz.core.SchedulerSignaler;
import org.quartz.core.TriggerFiredResult;
import org.quartz.exceptions.JobPersistenceException;
import org.quartz.exceptions.ObjectAlreadyExistsException;
import org.quartz.exceptions.SchedulerConfigException;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.JobDetail;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.Trigger;

public interface JobStore {
    public void initialize(SchedulerSignaler var1) throws SchedulerConfigException;

    public void schedulerStarted() throws SchedulerException;

    public void storeJobAndTrigger(JobDetail var1, OperableTrigger var2) throws ObjectAlreadyExistsException, JobPersistenceException;

    public void storeJob(JobDetail var1, boolean var2) throws ObjectAlreadyExistsException, JobPersistenceException;

    public boolean removeJob(String var1) throws JobPersistenceException;

    public JobDetail retrieveJob(String var1) throws JobPersistenceException;

    public void storeTrigger(OperableTrigger var1, boolean var2) throws ObjectAlreadyExistsException, JobPersistenceException;

    public boolean removeTrigger(String var1) throws JobPersistenceException;

    public boolean replaceTrigger(String var1, OperableTrigger var2) throws JobPersistenceException;

    public OperableTrigger retrieveTrigger(String var1) throws JobPersistenceException;

    public Calendar retrieveCalendar(String var1) throws JobPersistenceException;

    public List<Trigger> getTriggersForJob(String var1) throws JobPersistenceException;

    public Set<String> getJobKeys() throws JobPersistenceException;

    public List<OperableTrigger> acquireNextTriggers(long var1, int var3, long var4) throws JobPersistenceException;

    public void releaseAcquiredTrigger(OperableTrigger var1) throws JobPersistenceException;

    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> var1) throws JobPersistenceException;

    public void triggeredJobComplete(OperableTrigger var1, JobDetail var2, Trigger.CompletedExecutionInstruction var3) throws JobPersistenceException;

    public void setThreadPoolSize(int var1);
}

