/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.ArrayList;
import java.util.List;
import org.quartz.core.JobRunShellFactory;
import org.quartz.core.JobStore;
import org.quartz.core.ThreadPool;
import org.quartz.plugins.SchedulerPlugin;

public class QuartzSchedulerResources {
    private String threadName;
    private ThreadPool threadPool;
    private JobStore jobStore;
    private JobRunShellFactory jobRunShellFactory;
    private List<SchedulerPlugin> schedulerPlugins = new ArrayList<SchedulerPlugin>(10);
    private boolean makeSchedulerThreadDaemon = false;
    private boolean threadsInheritInitializersClassLoadContext = false;
    private long batchTimeWindow;
    private int maxBatchSize;

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        if (threadName == null || threadName.trim().length() == 0) {
            throw new IllegalArgumentException("Scheduler thread name cannot be empty.");
        }
        this.threadName = threadName;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        if (threadPool == null) {
            throw new IllegalArgumentException("ThreadPool cannot be null.");
        }
        this.threadPool = threadPool;
    }

    public JobStore getJobStore() {
        return this.jobStore;
    }

    public void setJobStore(JobStore jobStore) {
        if (jobStore == null) {
            throw new IllegalArgumentException("JobStore cannot be null.");
        }
        this.jobStore = jobStore;
    }

    public JobRunShellFactory getJobRunShellFactory() {
        return this.jobRunShellFactory;
    }

    public void setJobRunShellFactory(JobRunShellFactory jobRunShellFactory) {
        if (jobRunShellFactory == null) {
            throw new IllegalArgumentException("JobRunShellFactory cannot be null.");
        }
        this.jobRunShellFactory = jobRunShellFactory;
    }

    public void addSchedulerPlugin(SchedulerPlugin plugin) {
        this.schedulerPlugins.add(plugin);
    }

    public List<SchedulerPlugin> getSchedulerPlugins() {
        return this.schedulerPlugins;
    }

    public boolean getMakeSchedulerThreadDaemon() {
        return this.makeSchedulerThreadDaemon;
    }

    public void setMakeSchedulerThreadDaemon(boolean makeSchedulerThreadDaemon) {
        this.makeSchedulerThreadDaemon = makeSchedulerThreadDaemon;
    }

    public boolean isThreadsInheritInitializersClassLoadContext() {
        return this.threadsInheritInitializersClassLoadContext;
    }

    public void setThreadsInheritInitializersClassLoadContext(boolean threadsInheritInitializersClassLoadContext) {
        this.threadsInheritInitializersClassLoadContext = threadsInheritInitializersClassLoadContext;
    }

    public long getBatchTimeWindow() {
        return this.batchTimeWindow;
    }

    public void setBatchTimeWindow(long batchTimeWindow) {
        this.batchTimeWindow = batchTimeWindow;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }
}

