/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.core.Calendar;
import org.quartz.core.JobStore;
import org.quartz.core.JobWrapper;
import org.quartz.core.SchedulerSignaler;
import org.quartz.core.TriggerFiredBundle;
import org.quartz.core.TriggerFiredResult;
import org.quartz.core.TriggerWrapper;
import org.quartz.core.TriggerWrapperComparator;
import org.quartz.exceptions.JobPersistenceException;
import org.quartz.exceptions.ObjectAlreadyExistsException;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.JobDetail;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAMJobStore
implements JobStore {
    private HashMap<String, JobWrapper> jobsByKey = new HashMap(1000);
    private HashMap<String, TriggerWrapper> wrappedTriggersByKey = new HashMap(1000);
    private TreeSet<TriggerWrapper> timeWrappedTriggers = new TreeSet<TriggerWrapper>(new TriggerWrapperComparator());
    private HashMap<String, Calendar> calendarsByName = new HashMap(25);
    private ArrayList<TriggerWrapper> wrappedTriggers = new ArrayList(1000);
    private final Object lock = new Object();
    private HashSet<String> blockedJobs = new HashSet();
    private long misfireThreshold = 5000L;
    private SchedulerSignaler mSignaler;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final AtomicLong ftrCtr = new AtomicLong(System.currentTimeMillis());

    @Override
    public void initialize(SchedulerSignaler signaler) {
        this.mSignaler = signaler;
        this.logger.info("RAMJobStore initialized.");
    }

    @Override
    public void schedulerStarted() throws SchedulerException {
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long misfireThreshold) {
        if (misfireThreshold < 1L) {
            throw new IllegalArgumentException("Misfirethreashold must be larger than 0");
        }
        this.misfireThreshold = misfireThreshold;
    }

    @Override
    public void storeJobAndTrigger(JobDetail newJob, OperableTrigger newTrigger) throws JobPersistenceException {
        this.storeJob(newJob, false);
        this.storeTrigger(newTrigger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJob(JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException {
        JobWrapper jw = new JobWrapper((JobDetail)newJob.clone());
        boolean repl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.jobsByKey.get(jw.key) != null) {
                if (!replaceExisting) {
                    throw new ObjectAlreadyExistsException(newJob);
                }
                repl = true;
            }
            if (!repl) {
                this.jobsByKey.put(jw.key, jw);
            } else {
                JobWrapper orig = this.jobsByKey.get(jw.key);
                orig.jobDetail = jw.jobDetail;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJob(String jobKey) {
        boolean found = false;
        Object object = this.lock;
        synchronized (object) {
            List<Trigger> triggers = this.getTriggersForJob(jobKey);
            for (Trigger trig : triggers) {
                this.removeTrigger(trig.getName());
                found = true;
            }
            found = this.jobsByKey.remove(jobKey) != null | found;
            if (found) {
                // empty if block
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTrigger(OperableTrigger newTrigger, boolean replaceExisting) throws JobPersistenceException {
        TriggerWrapper tw = new TriggerWrapper((OperableTrigger)newTrigger.clone());
        Object object = this.lock;
        synchronized (object) {
            if (this.wrappedTriggersByKey.get(tw.key) != null) {
                if (!replaceExisting) {
                    throw new ObjectAlreadyExistsException(newTrigger);
                }
                this.removeTrigger(newTrigger.getName());
            }
            if (this.retrieveJob(newTrigger.getJobName()) == null) {
                throw new JobPersistenceException("The job (" + newTrigger.getJobName() + ") referenced by the trigger does not exist.");
            }
            this.wrappedTriggers.add(tw);
            this.wrappedTriggersByKey.put(tw.key, tw);
            if (this.blockedJobs.contains(tw.jobKey)) {
                tw.state = 5;
            } else {
                this.timeWrappedTriggers.add(tw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTrigger(String triggerName) {
        boolean found = false;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = found = this.wrappedTriggersByKey.remove(triggerName) != null;
            if (found) {
                TriggerWrapper tw = null;
                Iterator<TriggerWrapper> tgs = this.wrappedTriggers.iterator();
                while (tgs.hasNext()) {
                    tw = tgs.next();
                    if (!triggerName.equals(tw.key)) continue;
                    tgs.remove();
                    break;
                }
                this.timeWrappedTriggers.remove(tw);
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceTrigger(String triggerKey, OperableTrigger newTrigger) throws JobPersistenceException {
        boolean found = false;
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = this.wrappedTriggersByKey.remove(triggerKey);
            boolean bl = found = tw != null;
            if (found) {
                if (!tw.getTrigger().getJobName().equals(newTrigger.getJobName())) {
                    throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
                }
                tw = null;
                Iterator<TriggerWrapper> tgs = this.wrappedTriggers.iterator();
                while (tgs.hasNext()) {
                    tw = tgs.next();
                    if (!triggerKey.equals(tw.key)) continue;
                    tgs.remove();
                    break;
                }
                this.timeWrappedTriggers.remove(tw);
                try {
                    this.storeTrigger(newTrigger, false);
                }
                catch (JobPersistenceException jpe) {
                    this.storeTrigger(tw.getTrigger(), false);
                    throw jpe;
                }
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobDetail retrieveJob(String jobKey) {
        Object object = this.lock;
        synchronized (object) {
            JobWrapper jw = this.jobsByKey.get(jobKey);
            return jw != null ? (JobDetail)jw.jobDetail.clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperableTrigger retrieveTrigger(String triggerKey) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = this.wrappedTriggersByKey.get(triggerKey);
            return tw != null ? (OperableTrigger)tw.getTrigger().clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Calendar retrieveCalendar(String calName) {
        Object object = this.lock;
        synchronized (object) {
            Calendar cal = this.calendarsByName.get(calName);
            if (cal != null) {
                return (Calendar)cal.clone();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Trigger> getTriggersForJob(String jobKey) {
        ArrayList<Trigger> trigList = new ArrayList<Trigger>();
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.wrappedTriggers.size(); ++i) {
                TriggerWrapper tw = this.wrappedTriggers.get(i);
                if (!tw.jobKey.equals(jobKey)) continue;
                trigList.add((OperableTrigger)tw.trigger.clone());
            }
        }
        return trigList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<TriggerWrapper> getTriggerWrappersForJob(String jobKey) {
        ArrayList<TriggerWrapper> trigList = new ArrayList<TriggerWrapper>();
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.wrappedTriggers.size(); ++i) {
                TriggerWrapper tw = this.wrappedTriggers.get(i);
                if (!tw.jobKey.equals(jobKey)) continue;
                trigList.add(tw);
            }
        }
        return trigList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyMisfire(TriggerWrapper tw) {
        Date tnft;
        long misfireTime = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            misfireTime -= this.getMisfireThreshold();
        }
        if ((tnft = tw.trigger.getNextFireTime()) == null || tnft.getTime() > misfireTime || tw.trigger.getMisfireInstruction() == -1) {
            return false;
        }
        Calendar cal = null;
        if (tw.trigger.getCalendarName() != null) {
            cal = this.retrieveCalendar(tw.trigger.getCalendarName());
        }
        this.mSignaler.notifyTriggerListenersMisfired((OperableTrigger)tw.trigger.clone());
        tw.trigger.updateAfterMisfire(cal);
        if (tw.trigger.getNextFireTime() == null) {
            tw.state = 3;
            this.mSignaler.notifySchedulerListenersFinalized(tw.trigger);
            Object object = this.lock;
            synchronized (object) {
                this.timeWrappedTriggers.remove(tw);
            }
        } else if (tnft.equals(tw.trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    private String getFiredTriggerRecordId() {
        return String.valueOf(ftrCtr.incrementAndGet());
    }

    @Override
    public List<OperableTrigger> acquireNextTriggers(long noLaterThan, int maxCount, long timeWindow) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<OperableTrigger> result = new ArrayList<OperableTrigger>();
            while (true) {
                TriggerWrapper tw;
                try {
                    tw = this.timeWrappedTriggers.first();
                    if (tw == null) {
                        return result;
                    }
                    this.timeWrappedTriggers.remove(tw);
                }
                catch (NoSuchElementException nsee) {
                    return result;
                }
                if (tw.trigger.getNextFireTime() == null) continue;
                if (this.applyMisfire(tw)) {
                    if (tw.trigger.getNextFireTime() == null) continue;
                    this.timeWrappedTriggers.add(tw);
                    continue;
                }
                if (tw.getTrigger().getNextFireTime().getTime() > noLaterThan + timeWindow) {
                    this.timeWrappedTriggers.add(tw);
                    return result;
                }
                tw.state = 1;
                tw.trigger.setFireInstanceId(this.getFiredTriggerRecordId());
                OperableTrigger trig = (OperableTrigger)tw.trigger.clone();
                result.add(trig);
                if (result.size() == maxCount) break;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAcquiredTrigger(OperableTrigger trigger) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = this.wrappedTriggersByKey.get(trigger.getName());
            if (tw != null && tw.state == 1) {
                tw.state = 0;
                this.timeWrappedTriggers.add(tw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> triggers) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<TriggerFiredResult> results = new ArrayList<TriggerFiredResult>();
            for (OperableTrigger trigger : triggers) {
                TriggerWrapper tw = this.wrappedTriggersByKey.get(trigger.getName());
                if (tw == null || tw.trigger == null || tw.state != 1) continue;
                Calendar cal = null;
                if (tw.trigger.getCalendarName() != null && (cal = this.retrieveCalendar(tw.trigger.getCalendarName())) == null) continue;
                Date prevFireTime = trigger.getPreviousFireTime();
                this.timeWrappedTriggers.remove(tw);
                tw.trigger.triggered(cal);
                trigger.triggered(cal);
                tw.state = 0;
                TriggerFiredBundle bndle = new TriggerFiredBundle(this.retrieveJob(tw.jobKey), trigger, cal, false, new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
                JobDetail job = bndle.getJobDetail();
                if (!job.isConcurrencyAllowed()) {
                    ArrayList<TriggerWrapper> trigs = this.getTriggerWrappersForJob(job.getName());
                    for (TriggerWrapper ttw : trigs) {
                        if (ttw.state == 0) {
                            ttw.state = 5;
                        }
                        if (ttw.state == 4) {
                            ttw.state = 6;
                        }
                        this.timeWrappedTriggers.remove(ttw);
                    }
                    this.blockedJobs.add(job.getName());
                } else if (tw.trigger.getNextFireTime() != null) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        this.timeWrappedTriggers.add(tw);
                    }
                }
                results.add(new TriggerFiredResult(bndle));
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggeredJobComplete(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction triggerInstCode) {
        Object object = this.lock;
        synchronized (object) {
            JobWrapper jw = this.jobsByKey.get(jobDetail.getName());
            TriggerWrapper tw = this.wrappedTriggersByKey.get(trigger.getName());
            if (jw != null) {
                JobDetail jd = jw.jobDetail;
                if (!jd.isConcurrencyAllowed()) {
                    this.blockedJobs.remove(jd.getName());
                    ArrayList<TriggerWrapper> trigs = this.getTriggerWrappersForJob(jd.getName());
                    for (TriggerWrapper ttw : trigs) {
                        if (ttw.state == 5) {
                            ttw.state = 0;
                            this.timeWrappedTriggers.add(ttw);
                        }
                        if (ttw.state != 6) continue;
                        ttw.state = 4;
                    }
                    this.mSignaler.signalSchedulingChange(0L);
                }
            } else {
                this.blockedJobs.remove(jobDetail.getName());
            }
            if (tw != null) {
                if (triggerInstCode == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER) {
                    if (trigger.getNextFireTime() == null) {
                        if (tw.getTrigger().getNextFireTime() == null) {
                            this.removeTrigger(trigger.getName());
                        }
                    } else {
                        this.removeTrigger(trigger.getName());
                        this.mSignaler.signalSchedulingChange(0L);
                    }
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                    tw.state = 3;
                    this.timeWrappedTriggers.remove(tw);
                    this.mSignaler.signalSchedulingChange(0L);
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                    this.logger.info("Trigger " + trigger.getName() + " set to ERROR state.");
                    tw.state = 7;
                    this.mSignaler.signalSchedulingChange(0L);
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                    this.logger.info("All triggers of Job " + trigger.getJobName() + " set to ERROR state.");
                    this.setAllTriggersOfJobToState(trigger.getJobName(), 7);
                    this.mSignaler.signalSchedulingChange(0L);
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                    this.setAllTriggersOfJobToState(trigger.getJobName(), 3);
                    this.mSignaler.signalSchedulingChange(0L);
                }
            }
        }
    }

    private void setAllTriggersOfJobToState(String jobKey, int state) {
        ArrayList<TriggerWrapper> tws = this.getTriggerWrappersForJob(jobKey);
        for (TriggerWrapper tw : tws) {
            tw.state = state;
            if (state == 0) continue;
            this.timeWrappedTriggers.remove(tw);
        }
    }

    @Override
    public void setThreadPoolSize(int poolSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getJobKeys() {
        HashSet outList = new HashSet();
        Object object = this.lock;
        synchronized (object) {
            for (JobWrapper jw : this.jobsByKey.values()) {
                if (jw == null) continue;
                outList.add(jw.jobDetail.getName());
            }
        }
        return outList == null ? Collections.emptySet() : outList;
    }
}

