/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.LinkedList;
import java.util.List;
import org.quartz.core.JobRunShell;
import org.quartz.core.ThreadPool;
import org.quartz.exceptions.SchedulerConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleThreadPool
implements ThreadPool {
    private int count = -1;
    private int prio = 5;
    private boolean isShutdown = false;
    private boolean handoffPending = false;
    private boolean inheritLoader = false;
    private boolean inheritGroup = true;
    private boolean makeThreadsDaemons = false;
    private ThreadGroup threadGroup;
    private final Object nextRunnableLock = new Object();
    private List<WorkerThread> workers;
    private LinkedList<WorkerThread> availWorkers = new LinkedList();
    private LinkedList<WorkerThread> busyWorkers = new LinkedList();
    private String threadNamePrefix;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String schedulerInstanceName;

    @Override
    public int getPoolSize() {
        return this.getThreadCount();
    }

    public void setThreadCount(int count) {
        this.count = count;
    }

    public int getThreadCount() {
        return this.count;
    }

    public void setThreadPriority(int prio) {
        this.prio = prio;
    }

    public int getThreadPriority() {
        return this.prio;
    }

    public void setThreadNamePrefix(String prfx) {
        this.threadNamePrefix = prfx;
    }

    public String getThreadNamePrefix() {
        if (this.threadNamePrefix == null) {
            this.threadNamePrefix = this.schedulerInstanceName + "-SimpleThreadPoolWorker";
        }
        return this.threadNamePrefix;
    }

    public boolean isThreadsInheritContextClassLoaderOfInitializingThread() {
        return this.inheritLoader;
    }

    public void setThreadsInheritContextClassLoaderOfInitializingThread(boolean inheritLoader) {
        this.inheritLoader = inheritLoader;
    }

    public boolean isThreadsInheritGroupOfInitializingThread() {
        return this.inheritGroup;
    }

    public void setThreadsInheritGroupOfInitializingThread(boolean inheritGroup) {
        this.inheritGroup = inheritGroup;
    }

    public boolean isMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean makeThreadsDaemons) {
        this.makeThreadsDaemons = makeThreadsDaemons;
    }

    public void setInstanceId(String schedInstId) {
    }

    @Override
    public void initialize() throws SchedulerConfigException {
        if (this.workers != null && this.workers.size() > 0) {
            return;
        }
        if (this.count <= 0) {
            throw new SchedulerConfigException("Thread count must be > 0");
        }
        if (this.prio <= 0 || this.prio > 9) {
            throw new SchedulerConfigException("Thread priority must be > 0 and <= 9");
        }
        if (this.isThreadsInheritGroupOfInitializingThread()) {
            this.threadGroup = Thread.currentThread().getThreadGroup();
        } else {
            ThreadGroup parent = this.threadGroup = Thread.currentThread().getThreadGroup();
            while (!parent.getName().equals("main")) {
                this.threadGroup = parent;
                parent = this.threadGroup.getParent();
            }
            this.threadGroup = new ThreadGroup(parent, this.schedulerInstanceName + "-SimpleThreadPool");
            if (this.isMakeThreadsDaemons()) {
                this.threadGroup.setDaemon(true);
            }
        }
        if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
            this.log.info("Job execution threads will use class loader of thread: " + Thread.currentThread().getName());
        }
        for (WorkerThread wt : this.createWorkerThreads(this.count)) {
            wt.start();
            this.availWorkers.add(wt);
        }
    }

    private List<WorkerThread> createWorkerThreads(int count) {
        this.workers = new LinkedList<WorkerThread>();
        for (int i = 1; i <= count; ++i) {
            WorkerThread wt = new WorkerThread(this, this.threadGroup, this.getThreadNamePrefix() + "-" + i, this.getThreadPriority(), this.isMakeThreadsDaemons());
            if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
                wt.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            }
            this.workers.add(wt);
        }
        return this.workers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.isShutdown = true;
            if (this.workers == null) {
                return;
            }
            for (WorkerThread wt : this.workers) {
                JobRunShell jobRunShell = wt.getRunnable();
                if (jobRunShell != null) {
                    this.log.info("Waiting for Job to shutdown: {}", (Object)wt.getRunnable().getJobName());
                }
                wt.shutdown();
                this.availWorkers.remove(wt);
            }
            this.nextRunnableLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runInThread(JobRunShell runnable) {
        if (runnable == null) {
            return false;
        }
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.handoffPending = true;
            while (this.availWorkers.size() < 1 && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.isShutdown) {
                WorkerThread wt = this.availWorkers.removeFirst();
                this.busyWorkers.add(wt);
                wt.run(runnable);
            } else {
                WorkerThread wt = new WorkerThread(this, this.threadGroup, "WorkerThread-LastJob", this.prio, this.isMakeThreadsDaemons(), runnable);
                this.busyWorkers.add(wt);
                this.workers.add(wt);
                wt.start();
            }
            this.nextRunnableLock.notifyAll();
            this.handoffPending = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int blockForAvailableThreads() {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            while ((this.availWorkers.size() < 1 || this.handoffPending) && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.availWorkers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAvailable(WorkerThread wt) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            if (!this.isShutdown) {
                this.availWorkers.add(wt);
            }
            this.busyWorkers.remove(wt);
            this.nextRunnableLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFromBusyWorkersList(WorkerThread wt) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.busyWorkers.remove(wt);
            this.nextRunnableLock.notifyAll();
        }
    }

    private class WorkerThread
    extends Thread {
        private volatile boolean run;
        private SimpleThreadPool tp;
        private JobRunShell runnable;
        private boolean runOnce;

        private WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon) {
            this(tp, threadGroup, name, prio, isDaemon, (JobRunShell)null);
        }

        private WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon, JobRunShell runnable) {
            super(threadGroup, name);
            this.run = true;
            this.runnable = null;
            this.runOnce = false;
            this.tp = tp;
            this.runnable = runnable;
            if (runnable != null) {
                this.runOnce = true;
            }
            this.setPriority(prio);
            this.setDaemon(isDaemon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                this.run = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(JobRunShell newRunnable) {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                if (this.runnable != null) {
                    throw new IllegalStateException("Already running a Runnable!");
                }
                this.runnable = newRunnable;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean ran = false;
            boolean shouldRun = false;
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                shouldRun = this.run;
            }
            while (shouldRun) {
                if (Thread.interrupted()) {
                    return;
                }
                try {
                    workerThread = this;
                    synchronized (workerThread) {
                        while (this.runnable == null && this.run) {
                            this.wait(500L);
                        }
                        if (this.runnable != null) {
                            ran = true;
                            this.runnable.run();
                        }
                    }
                }
                catch (InterruptedException unblock) {
                    SimpleThreadPool.this.log.error("Worker thread was interrupt()'ed.", (Throwable)unblock);
                }
                catch (Throwable exceptionInRunnable) {
                    SimpleThreadPool.this.log.error("Error while executing the Runnable: ", exceptionInRunnable);
                }
                finally {
                    WorkerThread unblock = this;
                    synchronized (unblock) {
                        this.runnable = null;
                    }
                    if (this.getPriority() != this.tp.getThreadPriority()) {
                        this.setPriority(this.tp.getThreadPriority());
                    }
                    if (this.runOnce) {
                        unblock = this;
                        synchronized (unblock) {
                            this.run = false;
                        }
                        SimpleThreadPool.this.clearFromBusyWorkersList(this);
                    } else if (ran) {
                        ran = false;
                        SimpleThreadPool.this.makeAvailable(this);
                    }
                }
                workerThread = this;
                synchronized (workerThread) {
                    shouldRun = this.run;
                }
            }
            SimpleThreadPool.this.log.debug("WorkerThread is shut down.");
        }

        public JobRunShell getRunnable() {
            return this.runnable;
        }
    }
}

