/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.Serializable;
import java.util.Arrays;
import org.quartz.builders.JobBuilder;
import org.quartz.jobs.Job;
import org.quartz.jobs.JobDataMap;
import org.quartz.jobs.JobDetail;

public class JobDetailImpl
implements Cloneable,
Serializable,
JobDetail {
    private String name;
    private Class<? extends Job> jobClass;
    private String description = "";
    private JobDataMap jobDataMap;
    private boolean isConcurrencyAllowed = false;

    public String toString() {
        return "name: '" + this.getName() + "', Job Class: " + (this.getJobClass() == null ? null : this.getJobClass().getName()) + ", description: " + this.getDescription() + " isConcurrencyAllowed: " + this.isConcurrencyAllowed() + ", jobDataMap: " + (this.jobDataMap == null ? "empty" : Arrays.toString(this.jobDataMap.entrySet().toArray()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Job name cannot be empty.");
        }
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Class<? extends Job> getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(Class<? extends Job> jobClass) {
        if (jobClass == null) {
            throw new IllegalArgumentException("Job class cannot be null.");
        }
        if (!Job.class.isAssignableFrom(jobClass)) {
            throw new IllegalArgumentException("Job class must implement the Job interface.");
        }
        this.jobClass = jobClass;
    }

    @Override
    public JobDataMap getJobDataMap() {
        if (this.jobDataMap == null) {
            this.jobDataMap = new JobDataMap();
        }
        return this.jobDataMap;
    }

    public void setJobDataMap(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public void setIsConcurrencyAllowed(boolean isConcurrencyAllowed) {
        this.isConcurrencyAllowed = isConcurrencyAllowed;
    }

    @Override
    public boolean isConcurrencyAllowed() {
        return this.isConcurrencyAllowed;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobDetail)) {
            return false;
        }
        JobDetail other = (JobDetail)obj;
        if (other.getName() == null || this.getName() == null) {
            return false;
        }
        return other.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public Object clone() {
        JobDetailImpl copy;
        try {
            copy = (JobDetailImpl)super.clone();
            if (this.jobDataMap != null) {
                copy.jobDataMap = this.jobDataMap.shallowCopy();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return copy;
    }

    @Override
    public JobBuilder getJobBuilder() {
        JobBuilder b = JobBuilder.newJobBuilder().ofType(this.getJobClass()).isConcurrencyAllowed(this.isConcurrencyAllowed()).usingJobData(this.getJobDataMap()).withDescription(this.getDescription()).withIdentity(this.getName());
        return b;
    }
}

