/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.management;

import org.quartz.core.Scheduler;
import org.quartz.exceptions.SchedulerException;
import org.quartz.plugins.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHookPlugin
implements SchedulerPlugin {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void initialize(String name, final Scheduler scheduler) throws SchedulerException {
        this.logger.info("Registering Quartz shutdown hook.");
        Thread t = new Thread("Quartz Shutdown-Hook"){

            @Override
            public void run() {
                ShutdownHookPlugin.this.logger.info("Shutting down Quartz...");
                try {
                    scheduler.shutdown();
                }
                catch (SchedulerException e) {
                    ShutdownHookPlugin.this.logger.info("Error shutting down Quartz: " + e.getMessage(), (Throwable)e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(t);
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }
}

