/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.triggers;

import java.util.Calendar;
import java.util.Date;
import org.quartz.exceptions.SchedulerException;
import org.quartz.triggers.AbstractTrigger;
import org.quartz.triggers.SimpleTrigger;

public class SimpleTriggerImpl
extends AbstractTrigger
implements SimpleTrigger {
    private static final int YEAR_TO_GIVEUP_SCHEDULING_AT = Calendar.getInstance().get(1) + 100;
    private int repeatCount = 0;
    private long repeatInterval = 0L;
    private int timesTriggered = 0;
    private final boolean complete = false;

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && startTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.startTime = startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    @Override
    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        if (repeatCount < 0 && repeatCount != -1) {
            throw new IllegalArgumentException("Repeat count must be >= 0, use the constant REPEAT_INDEFINITELY for infinite.");
        }
        this.repeatCount = repeatCount;
    }

    @Override
    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(long repeatInterval) {
        if (repeatInterval < 0L) {
            throw new IllegalArgumentException("Repeat interval must be >= 0");
        }
        this.repeatInterval = repeatInterval;
    }

    @Override
    public int getTimesTriggered() {
        return this.timesTriggered;
    }

    public void setTimesTriggered(int timesTriggered) {
        this.timesTriggered = timesTriggered;
    }

    @Override
    protected boolean validateMisfireInstruction(int misfireInstruction) {
        if (misfireInstruction < 0) {
            return false;
        }
        return misfireInstruction <= 5;
    }

    @Override
    public void updateAfterMisfire(org.quartz.core.Calendar cal) {
        int instr = this.getMisfireInstruction();
        if (instr == -1) {
            return;
        }
        if (instr == 0) {
            instr = this.getRepeatCount() == 0 ? 1 : (this.getRepeatCount() == -1 ? 4 : 2);
        } else if (instr == 1 && this.getRepeatCount() != 0) {
            instr = 3;
        }
        if (instr == 1) {
            this.setNextFireTime(new Date());
        } else if (instr == 5) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime()) && (newFireTime = this.getFireTimeAfter(newFireTime)) != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(newFireTime);
                if (c.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
                newFireTime = null;
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 4) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime()) && (newFireTime = this.getFireTimeAfter(newFireTime)) != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(newFireTime);
                if (c.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
                newFireTime = null;
            }
            if (newFireTime != null) {
                int timesMissed = this.computeNumTimesFiredBetween(this.nextFireTime, newFireTime);
                this.setTimesTriggered(this.getTimesTriggered() + timesMissed);
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 2) {
            Date newFireTime = new Date();
            if (this.repeatCount != 0 && this.repeatCount != -1) {
                this.setRepeatCount(this.getRepeatCount() - this.getTimesTriggered());
                this.setTimesTriggered(0);
            }
            if (this.getEndTime() != null && this.getEndTime().before(newFireTime)) {
                this.setNextFireTime(null);
            } else {
                this.setStartTime(newFireTime);
                this.setNextFireTime(newFireTime);
            }
        } else if (instr == 3) {
            Date newFireTime = new Date();
            int timesMissed = this.computeNumTimesFiredBetween(this.nextFireTime, newFireTime);
            if (this.repeatCount != 0 && this.repeatCount != -1) {
                int remainingCount = this.getRepeatCount() - (this.getTimesTriggered() + timesMissed);
                if (remainingCount <= 0) {
                    remainingCount = 0;
                }
                this.setRepeatCount(remainingCount);
                this.setTimesTriggered(0);
            }
            if (this.getEndTime() != null && this.getEndTime().before(newFireTime)) {
                this.setNextFireTime(null);
            } else {
                this.setStartTime(newFireTime);
                this.setNextFireTime(newFireTime);
            }
        }
    }

    @Override
    public void triggered(org.quartz.core.Calendar calendar) {
        ++this.timesTriggered;
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            Calendar c = Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
            this.nextFireTime = null;
        }
    }

    @Override
    public Date computeFirstFireTime(org.quartz.core.Calendar calendar) {
        this.nextFireTime = this.getStartTime();
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            Calendar c = Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) <= YEAR_TO_GIVEUP_SCHEDULING_AT) continue;
            return null;
        }
        return this.nextFireTime;
    }

    @Override
    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    @Override
    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    @Override
    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    @Override
    public Date getFireTimeAfter(Date afterTime) {
        long endMillis;
        if (this.timesTriggered > this.repeatCount && this.repeatCount != -1) {
            return null;
        }
        if (afterTime == null) {
            afterTime = new Date();
        }
        if (this.repeatCount == 0 && afterTime.compareTo(this.getStartTime()) >= 0) {
            return null;
        }
        long startMillis = this.getStartTime().getTime();
        long afterMillis = afterTime.getTime();
        long l = endMillis = this.getEndTime() == null ? Long.MAX_VALUE : this.getEndTime().getTime();
        if (endMillis <= afterMillis) {
            return null;
        }
        if (afterMillis < startMillis) {
            return new Date(startMillis);
        }
        long numberOfTimesExecuted = (afterMillis - startMillis) / this.repeatInterval + 1L;
        if (numberOfTimesExecuted > (long)this.repeatCount && this.repeatCount != -1) {
            return null;
        }
        Date time = new Date(startMillis + numberOfTimesExecuted * this.repeatInterval);
        if (endMillis <= time.getTime()) {
            return null;
        }
        return time;
    }

    private Date getFireTimeBefore(Date end) {
        if (end.getTime() < this.getStartTime().getTime()) {
            return null;
        }
        int numFires = this.computeNumTimesFiredBetween(this.getStartTime(), end);
        return new Date(this.getStartTime().getTime() + (long)numFires * this.repeatInterval);
    }

    private int computeNumTimesFiredBetween(Date start, Date end) {
        if (this.repeatInterval < 1L) {
            return 0;
        }
        long time = end.getTime() - start.getTime();
        return (int)(time / this.repeatInterval);
    }

    @Override
    public Date getFinalFireTime() {
        if (this.repeatCount == 0) {
            return this.startTime;
        }
        if (this.repeatCount == -1) {
            return this.getEndTime() == null ? null : this.getFireTimeBefore(this.getEndTime());
        }
        long lastTrigger = this.startTime.getTime() + (long)this.repeatCount * this.repeatInterval;
        if (this.getEndTime() == null || lastTrigger < this.getEndTime().getTime()) {
            return new Date(lastTrigger);
        }
        return this.getFireTimeBefore(this.getEndTime());
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    public void validate() throws SchedulerException {
        super.validate();
        if (this.repeatCount != 0 && this.repeatInterval < 1L) {
            throw new SchedulerException("Repeat Interval cannot be zero.");
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", repeatCount: " + this.getRepeatCount() + ", repeatInterval: " + this.getRepeatInterval();
    }
}

