/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.yank;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.knowm.yank.YankPoolManager;
import org.knowm.yank.exceptions.SQLStatementNotFoundException;
import org.knowm.yank.handlers.InsertedIDResultSetHandler;
import org.knowm.yank.processors.YankBeanProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Yank {
    private static final YankPoolManager YANK_POOL_MANAGER = YankPoolManager.INSTANCE;
    private static Logger logger = LoggerFactory.getLogger(Yank.class);
    private static final String BEAN_EXCEPTION_MESSAGE = "Error converting row to bean!! Make sure you have a default no-args constructor!";
    private static final String QUERY_EXCEPTION_MESSAGE = "Error in SQL query!!!";

    private Yank() {
    }

    public static Long insertSQLKey(String sqlKey, Object[] params) {
        return Yank.insertSQLKey("yank-default", sqlKey, params);
    }

    public static Long insertSQLKey(String poolName, String sqlKey, Object[] params) {
        String sql = YANK_POOL_MANAGER.getMergedSqlProperties().getProperty(sqlKey);
        if (sql == null || sql.equalsIgnoreCase("")) {
            throw new SQLStatementNotFoundException();
        }
        return Yank.insert(poolName, sql, params);
    }

    public static Long insert(String sql, Object[] params) {
        return Yank.insert("yank-default", sql, params);
    }

    public static Long insert(String poolName, String sql, Object[] params) {
        Long returnLong = null;
        try {
            InsertedIDResultSetHandler rsh = new InsertedIDResultSetHandler();
            returnLong = (Long)new QueryRunner((DataSource)YANK_POOL_MANAGER.getConnectionPool(poolName)).insert(sql, (ResultSetHandler)rsh, params);
        }
        catch (SQLException e) {
            Yank.handleSQLException(e);
        }
        return returnLong == null ? 0L : returnLong;
    }

    public static int executeSQLKey(String sqlKey, Object[] params) {
        return Yank.executeSQLKey("yank-default", sqlKey, params);
    }

    public static int executeSQLKey(String poolName, String sqlKey, Object[] params) {
        String sql = YANK_POOL_MANAGER.getMergedSqlProperties().getProperty(sqlKey);
        if (sql == null || sql.equalsIgnoreCase("")) {
            throw new SQLStatementNotFoundException();
        }
        return Yank.execute(poolName, sql, params);
    }

    public static int execute(String sql, Object[] params) {
        return Yank.execute("yank-default", sql, params);
    }

    public static int execute(String poolName, String sql, Object[] params) {
        int returnInt = 0;
        try {
            returnInt = new QueryRunner((DataSource)YANK_POOL_MANAGER.getConnectionPool(poolName)).update(sql, params);
        }
        catch (SQLException e) {
            Yank.handleSQLException(e);
        }
        return returnInt;
    }

    public static <T> T queryScalarSQLKey(String sqlKey, Class<T> scalarType, Object[] params) {
        return Yank.queryScalarSQLKey("yank-default", sqlKey, scalarType, params);
    }

    public static <T> T queryScalarSQLKey(String poolName, String sqlKey, Class<T> scalarType, Object[] params) {
        String sql = YANK_POOL_MANAGER.getMergedSqlProperties().getProperty(sqlKey);
        if (sql == null || sql.equalsIgnoreCase("")) {
            throw new SQLStatementNotFoundException();
        }
        return Yank.queryScalar(poolName, sql, scalarType, params);
    }

    public static <T> T queryScalar(String sql, Class<T> scalarType, Object[] params) {
        return Yank.queryScalar("yank-default", sql, scalarType, params);
    }

    public static <T> T queryScalar(String poolName, String sql, Class<T> scalarType, Object[] params) {
        Object returnObject = null;
        try {
            ScalarHandler resultSetHandler = new ScalarHandler();
            returnObject = new QueryRunner((DataSource)YANK_POOL_MANAGER.getConnectionPool(poolName)).query(sql, (ResultSetHandler)resultSetHandler, params);
        }
        catch (SQLException e) {
            Yank.handleSQLException(e);
        }
        return (T)returnObject;
    }

    public static <T> T queryBeanSQLKey(String sqlKey, Class<T> beanType, Object[] params) {
        return Yank.queryBeanSQLKey("yank-default", sqlKey, beanType, params);
    }

    public static <T> T queryBeanSQLKey(String poolName, String sqlKey, Class<T> beanType, Object[] params) {
        String sql = YANK_POOL_MANAGER.getMergedSqlProperties().getProperty(sqlKey);
        if (sql == null || sql.equalsIgnoreCase("")) {
            throw new SQLStatementNotFoundException();
        }
        return Yank.queryBean(poolName, sql, beanType, params);
    }

    public static <T> T queryBean(String sql, Class<T> beanType, Object[] params) {
        return Yank.queryBean("yank-default", sql, beanType, params);
    }

    public static <T> T queryBean(String poolName, String sql, Class<T> beanType, Object[] params) {
        Object returnObject = null;
        try {
            BeanHandler resultSetHandler = new BeanHandler(beanType, (RowProcessor)new BasicRowProcessor(new YankBeanProcessor<T>(beanType)));
            returnObject = new QueryRunner((DataSource)YANK_POOL_MANAGER.getConnectionPool(poolName)).query(sql, (ResultSetHandler)resultSetHandler, params);
        }
        catch (SQLException e) {
            Yank.handleSQLException(e);
        }
        return (T)returnObject;
    }

    public static <T> List<T> queryBeanListSQLKey(String sqlKey, Class<T> beanType, Object[] params) {
        return Yank.queryBeanListSQLKey("yank-default", sqlKey, beanType, params);
    }

    public static <T> List<T> queryBeanListSQLKey(String poolName, String sqlKey, Class<T> beanType, Object[] params) {
        String sql = YANK_POOL_MANAGER.getMergedSqlProperties().getProperty(sqlKey);
        if (sql == null || sql.equalsIgnoreCase("")) {
            throw new SQLStatementNotFoundException();
        }
        return Yank.queryBeanList(poolName, sql, beanType, params);
    }

    public static <T> List<T> queryBeanList(String sql, Class<T> beanType, Object[] params) {
        return Yank.queryBeanList("yank-default", sql, beanType, params);
    }

    public static <T> List<T> queryBeanList(String poolName, String sql, Class<T> beanType, Object[] params) {
        List returnList = null;
        try {
            BeanListHandler resultSetHandler = new BeanListHandler(beanType, (RowProcessor)new BasicRowProcessor(new YankBeanProcessor<T>(beanType)));
            returnList = (List)new QueryRunner((DataSource)YANK_POOL_MANAGER.getConnectionPool(poolName)).query(sql, (ResultSetHandler)resultSetHandler, params);
        }
        catch (SQLException e) {
            Yank.handleSQLException(e);
        }
        return returnList;
    }

    public static <T> List<T> queryColumnSQLKey(String sqlKey, String columnName, Class<T> columnType, Object[] params) {
        return Yank.queryColumnSQLKey("yank-default", sqlKey, columnName, columnType, params);
    }

    public static <T> List<T> queryColumnSQLKey(String poolName, String sqlKey, String columnName, Class<T> columnType, Object[] params) {
        String sql = YANK_POOL_MANAGER.getMergedSqlProperties().getProperty(sqlKey);
        if (sql == null || sql.equalsIgnoreCase("")) {
            throw new SQLStatementNotFoundException();
        }
        return Yank.queryColumn(poolName, sql, columnName, columnType, params);
    }

    public static <T> List<T> queryColumn(String sql, String columnName, Class<T> columnType, Object[] params) {
        return Yank.queryColumn("yank-default", sql, columnName, columnType, params);
    }

    public static <T> List<T> queryColumn(String poolName, String sql, String columnName, Class<T> columnType, Object[] params) {
        List returnList = null;
        try {
            ColumnListHandler resultSetHandler = new ColumnListHandler(columnName);
            returnList = (List)new QueryRunner((DataSource)YANK_POOL_MANAGER.getConnectionPool(poolName)).query(sql, (ResultSetHandler)resultSetHandler, params);
        }
        catch (SQLException e) {
            Yank.handleSQLException(e);
        }
        return returnList;
    }

    public static List<Object[]> queryObjectArraysSQLKey(String sqlKey, Object[] params) {
        return Yank.queryObjectArraysSQLKey("yank-default", sqlKey, params);
    }

    public static List<Object[]> queryObjectArraysSQLKey(String poolName, String sqlKey, Object[] params) {
        String sql = YANK_POOL_MANAGER.getMergedSqlProperties().getProperty(sqlKey);
        if (sql == null || sql.equalsIgnoreCase("")) {
            throw new SQLStatementNotFoundException();
        }
        return Yank.queryObjectArrays(poolName, sql, params);
    }

    public static List<Object[]> queryObjectArrays(String sql, Object[] params) {
        return Yank.queryObjectArrays("yank-default", sql, params);
    }

    public static List<Object[]> queryObjectArrays(String poolName, String sql, Object[] params) {
        List returnList = null;
        try {
            ArrayListHandler resultSetHandler = new ArrayListHandler();
            returnList = (List)new QueryRunner((DataSource)YANK_POOL_MANAGER.getConnectionPool(poolName)).query(sql, (ResultSetHandler)resultSetHandler, params);
        }
        catch (SQLException e) {
            Yank.handleSQLException(e);
        }
        return returnList;
    }

    public static int[] executeBatchSQLKey(String sqlKey, Object[][] params) {
        return Yank.executeBatchSQLKey("yank-default", sqlKey, params);
    }

    public static int[] executeBatchSQLKey(String poolName, String sqlKey, Object[][] params) {
        String sql = YANK_POOL_MANAGER.getMergedSqlProperties().getProperty(sqlKey);
        if (sql == null || sql.equalsIgnoreCase("")) {
            throw new SQLStatementNotFoundException();
        }
        return Yank.executeBatch(poolName, sql, params);
    }

    public static int[] executeBatch(String sql, Object[][] params) {
        return Yank.executeBatch("yank-default", sql, params);
    }

    public static int[] executeBatch(String poolName, String sql, Object[][] params) {
        int[] returnIntArray = null;
        try {
            returnIntArray = new QueryRunner((DataSource)YANK_POOL_MANAGER.getConnectionPool(poolName)).batch(sql, params);
        }
        catch (SQLException e) {
            Yank.handleSQLException(e);
        }
        return returnIntArray;
    }

    private static void handleSQLException(SQLException e) {
        if (e.getMessage().startsWith("Cannot create")) {
            logger.error(BEAN_EXCEPTION_MESSAGE, (Throwable)e);
        } else {
            logger.error(QUERY_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Deprecated
    public static void setupDataSource(Properties dataSourceProperties) {
        Yank.setupDefaultConnectionPool(dataSourceProperties);
    }

    public static void setupConnectionPool(String poolName, Properties dataSourceProperties) {
        YANK_POOL_MANAGER.addConnectionPool(poolName, dataSourceProperties);
    }

    public static void setupDefaultConnectionPool(Properties dataSourceProperties) {
        YANK_POOL_MANAGER.addDefaultConnectionPool(dataSourceProperties);
    }

    public static void addSQLStatements(Properties sqlProperties) {
        YANK_POOL_MANAGER.addSQLStatements(sqlProperties);
    }

    @Deprecated
    public static synchronized void releaseDataSource() {
        YANK_POOL_MANAGER.releaseDefaultConnectionPool();
    }

    public static synchronized void releaseConnectionPool(String poolName) {
        YANK_POOL_MANAGER.releaseConnectionPool(poolName);
    }

    public static synchronized void releaseDefaultConnectionPool() {
        YANK_POOL_MANAGER.releaseDefaultConnectionPool();
    }

    public static synchronized void releaseAllConnectionPools() {
        YANK_POOL_MANAGER.releaseAllConnectionPools();
    }

    public static HikariDataSource getDefaultConnectionPool() {
        return YANK_POOL_MANAGER.getDefaultConnectionPool();
    }

    public static HikariDataSource getConnectionPool(String poolName) {
        return YANK_POOL_MANAGER.getConnectionPool(poolName);
    }

    @Deprecated
    public static HikariDataSource getDataSource() {
        return Yank.getDefaultConnectionPool();
    }
}

