/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.util.Collection;
import java.util.Iterator;
import org.kocakosm.pitaya.collection.AbstractBag;
import org.kocakosm.pitaya.collection.Bag;
import org.kocakosm.pitaya.collection.Iterators;
import org.kocakosm.pitaya.util.Parameters;

public final class Bags {
    public static final Bag EMPTY_BAG = new EmptyBag();

    public static <E> Bag<E> emptyBag() {
        return EMPTY_BAG;
    }

    private Bags() {
    }

    private static final class EmptyBag<E>
    extends AbstractBag<E> {
        private EmptyBag() {
        }

        @Override
        public int count(E e) {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Parameters.checkNotNull(c);
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

