/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.RandomAccess;
import org.kocakosm.pitaya.collection.Iterables;
import org.kocakosm.pitaya.collection.Iterators;

public final class ImmutableList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 5355899738233743694L;
    private final List<E> inner;

    public static <E> List<E> copyOf(Collection<? extends E> c) {
        return new ImmutableList<E>(new ArrayList<E>(c));
    }

    public static <E> List<E> copyOf(Iterable<? extends E> i) {
        return new ImmutableList<E>(Iterables.toList(i));
    }

    public static <E> List<E> copyOf(Iterator<? extends E> i) {
        return new ImmutableList<E>(Iterators.toList(i));
    }

    public static <E> List<E> copyOf(E[] values) {
        return new ImmutableList<E>(Arrays.asList(values));
    }

    public static <E> List<E> of(E ... values) {
        return new ImmutableList<E>(Arrays.asList(values));
    }

    private ImmutableList(List<E> inner) {
        this.inner = inner;
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new UnmodifiableListIterator<E>(this.inner.listIterator());
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.inner.toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.inner.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        return this.inner.get(index);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.inner.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.inner.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new UnmodifiableListIterator<E>(this.inner.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new UnmodifiableListIterator<E>(this.inner.listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ImmutableList<E>(this.inner.subList(fromIndex, toIndex));
    }

    private static final class UnmodifiableListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> inner;

        UnmodifiableListIterator(ListIterator<E> iterator) {
            this.inner = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public E next() {
            return this.inner.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.inner.hasPrevious();
        }

        @Override
        public E previous() {
            return this.inner.previous();
        }

        @Override
        public int nextIndex() {
            return this.inner.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.inner.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Builder<E> {
        private final List<E> inner = new ArrayList();

        public Builder<E> add(E ... values) {
            this.inner.addAll(Arrays.asList(values));
            return this;
        }

        public Builder<E> add(Iterable<? extends E> values) {
            for (E value : values) {
                this.inner.add(value);
            }
            return this;
        }

        public Builder<E> add(Iterator<? extends E> values) {
            while (values.hasNext()) {
                this.inner.add(values.next());
            }
            return this;
        }

        public Builder<E> sort() {
            Object[] values = this.inner.toArray();
            Arrays.sort(values);
            return new Builder<Object>().add(values);
        }

        public Builder<E> sort(Comparator<? super E> c) {
            Collections.sort(this.inner, c);
            return this;
        }

        public Builder<E> reverse() {
            Collections.reverse(this.inner);
            return this;
        }

        public Builder<E> rotate(int n) {
            Collections.rotate(this.inner, n);
            return this;
        }

        public Builder<E> shuffle() {
            Collections.shuffle(this.inner);
            return this;
        }

        public Builder<E> shuffle(Random random) {
            Collections.shuffle(this.inner, random);
            return this;
        }

        public List<E> build() {
            return new ImmutableList(this.inner);
        }
    }
}

