/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicLong;
import org.kocakosm.pitaya.util.Parameters;

public final class CountingWriter
extends Writer {
    private final Writer out;
    private final AtomicLong counter;

    public CountingWriter(Writer out) {
        Parameters.checkNotNull(out);
        this.out = out;
        this.counter = new AtomicLong();
    }

    public long getCount() {
        return this.counter.get();
    }

    public long resetCount() {
        return this.counter.getAndSet(0L);
    }

    @Override
    public Writer append(char c) throws IOException {
        this.out.append(c);
        this.counter.incrementAndGet();
        return this;
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        CharSequence sequence = csq == null ? "null" : csq;
        this.out.append(sequence);
        this.counter.addAndGet(sequence.length());
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        CharSequence sequence = csq == null ? "null" : csq;
        this.out.append(sequence.subSequence(start, end));
        this.counter.addAndGet(sequence.subSequence(start, end).length());
        return this;
    }

    @Override
    public void write(int c) throws IOException {
        this.out.write(c);
        this.counter.incrementAndGet();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.out.write(cbuf);
        this.counter.addAndGet(cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
        this.counter.addAndGet(Math.min(cbuf.length - off, len));
    }

    @Override
    public void write(String str) throws IOException {
        this.out.write(str);
        this.counter.addAndGet(str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.out.write(str, off, len);
        this.counter.addAndGet(Math.min(str.length() - off, len));
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

