/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Set;
import org.kocakosm.pitaya.collection.ImmutableSet;
import org.kocakosm.pitaya.io.ByteStreams;
import org.kocakosm.pitaya.io.IO;
import org.kocakosm.pitaya.io.WriteOption;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.XArrays;

public final class XFiles {
    public static void cp(File src, File dst) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(src + " doesn't exist");
        }
        Parameters.checkCondition(!dst.exists() || dst.isDirectory() || src.isFile() && dst.isFile());
        if (src.isDirectory()) {
            XFiles.copyDirectory(src, dst);
        } else if (src.isFile()) {
            XFiles.copyFile(src, dst);
        } else {
            throw new IOException(src + " is neither a directory nor a regular file");
        }
    }

    private static void copyDirectory(File src, File dst) throws IOException {
        if (dst.isDirectory()) {
            XFiles.cp(src, new File(dst, src.getName()));
        } else {
            XFiles.mkdir(dst);
            for (File f : src.listFiles()) {
                XFiles.cp(f, new File(dst, f.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyFile(File src, File dst) throws IOException {
        if (dst.isDirectory()) {
            XFiles.cp(src, new File(dst, src.getName()));
            return;
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = XFiles.newInputStream(src);
            out = XFiles.newOutputStream(dst, new WriteOption[0]);
            ByteStreams.copy(in, out);
        }
        catch (Throwable throwable) {
            IO.close(in);
            IO.close(out);
            throw throwable;
        }
        IO.close(in);
        IO.close(out);
    }

    public static void cp(File src, OutputStream dst) throws IOException {
        BufferedInputStream in = XFiles.newInputStream(src);
        try {
            ByteStreams.copy(in, dst);
        }
        finally {
            IO.close(in);
        }
    }

    public static void cp(InputStream src, File dst) throws IOException {
        BufferedOutputStream out = XFiles.newOutputStream(dst, new WriteOption[0]);
        try {
            ByteStreams.copy(src, out);
        }
        finally {
            IO.close(out);
        }
    }

    public static void mkdir(File ... paths) throws IOException {
        for (File path : paths) {
            XFiles.createDirectory(path);
        }
    }

    private static void createDirectory(File f) throws IOException {
        if (f.exists()) {
            if (!f.isDirectory()) {
                throw new IOException(f + " exists and is not a directory");
            }
        } else if (!f.mkdirs()) {
            throw new IOException("Failed to create " + f);
        }
    }

    public static void mv(File src, File dst) throws IOException {
        Parameters.checkNotNull(dst);
        if (!src.equals(dst)) {
            XFiles.cp(src, dst);
            try {
                XFiles.rm(src);
            }
            catch (IOException e) {
                XFiles.rm(dst);
                throw new IOException("Can't move " + src, e);
            }
        }
    }

    public static void rm(File ... files) throws IOException {
        for (File f : files) {
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                XFiles.rm(f.listFiles());
            }
            if (f.delete()) continue;
            throw new IOException("Can't delete " + f);
        }
    }

    public static void touch(File ... files) throws IOException {
        long now = System.currentTimeMillis();
        for (File f : files) {
            if (f.createNewFile() || f.setLastModified(now)) continue;
            throw new IOException("Failed to touch " + f);
        }
    }

    public static byte[] head(File f) throws IOException {
        return XFiles.head(f, 512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] head(File f, int n) throws IOException {
        Parameters.checkCondition(n >= 0);
        BufferedInputStream in = XFiles.newInputStream(f);
        byte[] buf = new byte[n];
        try {
            byte[] byArray = XArrays.copyOf(buf, 0, ((InputStream)in).read(buf));
            return byArray;
        }
        finally {
            IO.close(in);
        }
    }

    public static byte[] tail(File f) throws IOException {
        return XFiles.tail(f, 512);
    }

    public static byte[] tail(File f, int n) throws IOException {
        Parameters.checkCondition(n >= 0);
        RandomAccessFile file = new RandomAccessFile(f, "r");
        file.seek(file.length() - (long)n);
        byte[] data = new byte[n];
        file.read(data);
        return data;
    }

    public static boolean equal(File f1, File f2) throws IOException {
        if (f1 == f2) {
            return true;
        }
        if (f1 == null || f2 == null || !XFiles.haveSameType(f1, f2)) {
            return false;
        }
        return f1.equals(f2) ? true : XFiles.haveSameContent(f1, f2);
    }

    private static boolean haveSameType(File f1, File f2) {
        return f1.isFile() == f2.isFile() && f1.isDirectory() == f2.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean haveSameContent(File f1, File f2) throws IOException {
        if (f1.isFile()) {
            BufferedInputStream in1 = null;
            BufferedInputStream in2 = null;
            try {
                in1 = XFiles.newInputStream(f1);
                in2 = XFiles.newInputStream(f2);
                boolean bl = ByteStreams.equal(in1, in2);
                return bl;
            }
            finally {
                IO.close(in1);
                IO.close(in2);
            }
        }
        File[] files = f1.listFiles();
        if (files.length != f2.listFiles().length) {
            return false;
        }
        for (File f : files) {
            if (XFiles.equal(f, new File(f2, f.getName()))) continue;
            return false;
        }
        return true;
    }

    public static String getBaseName(File f) {
        String fileName = f.getName();
        int index = fileName.lastIndexOf(46);
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    public static String getExtension(File f) {
        String fileName = f.getName();
        int index = fileName.lastIndexOf(46);
        return index == -1 ? "" : fileName.substring(index + 1);
    }

    public static BufferedInputStream newInputStream(File f) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(f));
    }

    public static BufferedOutputStream newOutputStream(File f, WriteOption ... options) throws IOException {
        Set<WriteOption> opts = ImmutableSet.of(options);
        XFiles.checkWriteOptions(opts);
        XFiles.checkFileExistence(f, opts);
        return new BufferedOutputStream(XFiles.newOutputStream(f, opts));
    }

    private static void checkWriteOptions(Set<WriteOption> options) {
        if (options.contains((Object)WriteOption.APPEND) && options.contains((Object)WriteOption.OVERWRITE) || options.contains((Object)WriteOption.CREATE) && options.size() > 1) {
            throw new IllegalArgumentException("Incompatible write options: " + options);
        }
    }

    private static void checkFileExistence(File f, Set<WriteOption> options) throws IOException {
        if (options.contains((Object)WriteOption.CREATE) && f.exists()) {
            throw new IOException((Object)((Object)WriteOption.CREATE) + ": " + f + " already exists");
        }
        if (options.contains((Object)WriteOption.UPDATE) && !f.exists()) {
            throw new FileNotFoundException((Object)((Object)WriteOption.UPDATE) + ": " + f + " doesn't exist");
        }
    }

    private static OutputStream newOutputStream(File f, Set<WriteOption> options) throws FileNotFoundException {
        if (options.contains((Object)WriteOption.APPEND)) {
            return new FileOutputStream(f, true);
        }
        if (options.contains((Object)WriteOption.OVERWRITE)) {
            RandomAccessFile file = new RandomAccessFile(f, "rw");
            FileChannel channel = file.getChannel();
            return Channels.newOutputStream(channel);
        }
        return new FileOutputStream(f);
    }

    public static byte[] read(File f) throws IOException {
        BufferedInputStream in = XFiles.newInputStream(f);
        try {
            byte[] byArray = ByteStreams.read(in);
            return byArray;
        }
        finally {
            IO.close(in);
        }
    }

    private XFiles() {
    }
}

