/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.math;

import java.math.BigDecimal;
import org.kocakosm.pitaya.util.Parameters;

public final class Numbers {
    public static long max(long ... values) {
        Parameters.checkCondition(values.length > 0);
        long max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    public static int max(int ... values) {
        Parameters.checkCondition(values.length > 0);
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    public static float max(float ... values) {
        Parameters.checkCondition(values.length > 0);
        float max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    public static double max(double ... values) {
        Parameters.checkCondition(values.length > 0);
        double max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    public static long min(long ... values) {
        Parameters.checkCondition(values.length > 0);
        long min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    public static int min(int ... values) {
        Parameters.checkCondition(values.length > 0);
        int min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    public static float min(float ... values) {
        Parameters.checkCondition(values.length > 0);
        float min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    public static double min(double ... values) {
        Parameters.checkCondition(values.length > 0);
        double min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    public static double mean(int ... values) {
        Parameters.checkCondition(values.length > 0);
        long sum = 0L;
        for (int value : values) {
            sum += (long)value;
        }
        return (double)sum / (double)values.length;
    }

    public static double mean(long ... values) {
        Parameters.checkCondition(values.length > 0);
        BigDecimal sum = BigDecimal.ZERO;
        for (long value : values) {
            sum = sum.add(BigDecimal.valueOf(value));
        }
        return sum.divide(BigDecimal.valueOf(values.length)).doubleValue();
    }

    public static double mean(double ... values) {
        Parameters.checkCondition(values.length > 0);
        BigDecimal sum = BigDecimal.ZERO;
        for (double value : values) {
            sum = sum.add(BigDecimal.valueOf(value));
        }
        return sum.divide(BigDecimal.valueOf(values.length)).doubleValue();
    }

    public static double mean(float ... values) {
        Parameters.checkCondition(values.length > 0);
        BigDecimal sum = BigDecimal.ZERO;
        for (float value : values) {
            sum = sum.add(BigDecimal.valueOf(value));
        }
        return sum.divide(BigDecimal.valueOf(values.length)).doubleValue();
    }

    public static boolean isFinite(float f) {
        return !Float.isInfinite(f) && !Float.isNaN(f);
    }

    public static boolean isFinite(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    public static long safeAbs(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException("Long overflow: abs(" + a + ")");
        }
        return Math.abs(a);
    }

    public static int safeAbs(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException("Int overflow: abs(" + a + ")");
        }
        return Math.abs(a);
    }

    public static long safeNegate(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException("Long overflow: -" + a);
        }
        return -a;
    }

    public static int safeNegate(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException("Int overflow: -" + a);
        }
        return -a;
    }

    public static long safeAdd(long a, long b) {
        long sum;
        if (a < 0L != (sum = a + b) < 0L && a < 0L == b < 0L) {
            throw new ArithmeticException("Long overflow: " + a + " + " + b);
        }
        return sum;
    }

    public static int safeAdd(int a, int b) {
        int sum;
        if (a < 0 != (sum = a + b) < 0 && a < 0 == b < 0) {
            throw new ArithmeticException("Int overflow: " + a + " + " + b);
        }
        return sum;
    }

    public static long safeSubtract(long a, long b) {
        long diff;
        if (a < 0L != (diff = a - b) < 0L && a < 0L != b < 0L) {
            throw new ArithmeticException("Long overflow: " + a + " - " + b);
        }
        return diff;
    }

    public static int safeSubtract(int a, int b) {
        int diff;
        if (a < 0 != (diff = a - b) < 0 && a < 0 != b < 0) {
            throw new ArithmeticException("Int overflow: " + a + " - " + b);
        }
        return diff;
    }

    public static long safeMultiply(long a, long b) {
        long max;
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long l = max = a < 0L == b < 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        if (b > 0L && b > max / a || b < 0L && b < max / a) {
            throw new ArithmeticException("Long overflow: " + a + " * " + b);
        }
        return a * b;
    }

    public static int safeMultiply(int a, int b) {
        long max;
        if (a == 0 || b == 0) {
            return 0;
        }
        long l = max = a < 0 == b < 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        if (b > 0 && (long)b > max / (long)a || b < 0 && (long)b < max / (long)a) {
            throw new ArithmeticException("Int overflow: " + a + " * " + b);
        }
        return a * b;
    }

    public static long safeDivide(long a, long b) {
        if (a == Long.MIN_VALUE && b == -1L) {
            throw new ArithmeticException("Long overflow: " + a + " / " + b);
        }
        return a / b;
    }

    public static int safeDivide(int a, int b) {
        if (a == Integer.MIN_VALUE && (long)b == -1L) {
            throw new ArithmeticException("Int overflow: " + a + " / " + b);
        }
        return a / b;
    }

    public static long safePow(long a, int b) {
        Parameters.checkCondition(b >= 0);
        if (b == 0) {
            return 1L;
        }
        long base = a;
        long result = 1L;
        try {
            for (int exponent = b; exponent > 1; exponent >>= 1) {
                if ((exponent & 1) != 0) {
                    result = Numbers.safeMultiply(result, base);
                    --exponent;
                }
                base = Numbers.safeMultiply(base, base);
            }
            return Numbers.safeMultiply(result, base);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Long overflow: " + a + " ^ " + b);
        }
    }

    public static int safePow(int a, int b) {
        Parameters.checkCondition(b >= 0);
        if (b == 0) {
            return 1;
        }
        int base = a;
        int result = 1;
        try {
            for (int exponent = b; exponent > 1; exponent >>= 1) {
                if ((exponent & 1) != 0) {
                    result = Numbers.safeMultiply(result, base);
                    --exponent;
                }
                base = Numbers.safeMultiply(base, base);
            }
            return Numbers.safeMultiply(result, base);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Int overflow: " + a + " ^ " + b);
        }
    }

    public static long gcd(long a, long b) {
        if (a < 0L || b < 0L) {
            return Numbers.gcd(Numbers.safeAbs(a), Numbers.safeAbs(b));
        }
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        int shift = 0;
        while (((a | b) & 1L) == 0L) {
            a >>= 1;
            b >>= 1;
            ++shift;
        }
        while ((a & 1L) == 0L) {
            a >>= 1;
        }
        while (true) {
            if ((b & 1L) == 0L) {
                b >>= 1;
                continue;
            }
            if (a > b) {
                long tmp = b;
                b = a;
                a = tmp;
            }
            if ((b -= a) == 0L) break;
        }
        return a << shift;
    }

    public static int gcd(int a, int b) {
        if (a < 0 || b < 0) {
            return Numbers.gcd(Numbers.safeAbs(a), Numbers.safeAbs(b));
        }
        return (int)Numbers.gcd((long)a, (long)b);
    }

    public static long lcm(long a, long b) {
        try {
            if (a < 0L || b < 0L) {
                return Numbers.lcm(Numbers.safeAbs(a), Numbers.safeAbs(b));
            }
            if (a == 0L) {
                return b;
            }
            if (b == 0L) {
                return a;
            }
            return Numbers.safeMultiply(a / Numbers.gcd(a, b), b);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Long overflow: lcm(" + a + ", " + b + ")");
        }
    }

    public static int lcm(int a, int b) {
        try {
            if (a < 0 || b < 0) {
                return Numbers.lcm(Numbers.safeAbs(a), Numbers.safeAbs(b));
            }
            if (a == 0) {
                return b;
            }
            if (b == 0) {
                return a;
            }
            return Numbers.safeMultiply(a / Numbers.gcd(a, b), b);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Int overflow: lcm(" + a + ", " + b + ")");
        }
    }

    public static int safeToInt(long a) {
        if (a >= Integer.MIN_VALUE && a <= Integer.MAX_VALUE) {
            return (int)a;
        }
        throw new ArithmeticException(a + " can't be cast to int");
    }

    private Numbers() {
    }
}

