/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.kocakosm.pitaya.security.AbstractDigest;
import org.kocakosm.pitaya.security.Digest;
import org.kocakosm.pitaya.security.Keccak;
import org.kocakosm.pitaya.security.MD2;
import org.kocakosm.pitaya.security.MD4;
import org.kocakosm.pitaya.util.CannotHappenException;

public final class Digests {
    public static Digest md2() {
        return new MD2();
    }

    public static Digest md4() {
        return new MD4();
    }

    public static Digest md5() {
        return BuiltInDigest.create("MD5");
    }

    public static Digest sha1() {
        return BuiltInDigest.create("SHA1");
    }

    public static Digest sha256() {
        return BuiltInDigest.create("SHA-256");
    }

    public static Digest sha512() {
        return BuiltInDigest.create("SHA-512");
    }

    public static Digest keccak224() {
        return new Keccak(28);
    }

    public static Digest keccak256() {
        return new Keccak(32);
    }

    public static Digest keccak384() {
        return new Keccak(48);
    }

    public static Digest keccak512() {
        return new Keccak(64);
    }

    private Digests() {
    }

    private static final class BuiltInDigest
    extends AbstractDigest {
        private final MessageDigest md;

        static Digest create(String algorithm) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CannotHappenException(ex);
            }
            return new BuiltInDigest(md);
        }

        private BuiltInDigest(MessageDigest md) {
            super(md.getAlgorithm(), md.getDigestLength());
            this.md = md;
        }

        @Override
        public Digest reset() {
            this.md.reset();
            return this;
        }

        @Override
        public Digest update(byte input) {
            this.md.update(input);
            return this;
        }

        @Override
        public Digest update(byte ... input) {
            this.md.update(input);
            return this;
        }

        @Override
        public Digest update(byte[] input, int off, int len) {
            this.md.update(input, off, len);
            return this;
        }

        @Override
        public byte[] digest() {
            return this.md.digest();
        }

        @Override
        public byte[] digest(byte ... input) {
            return this.md.digest(input);
        }

        @Override
        public byte[] digest(byte[] input, int off, int len) {
            this.md.update(input, off, len);
            return this.md.digest();
        }
    }
}

