/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import java.util.Arrays;
import org.kocakosm.pitaya.security.Algorithm;
import org.kocakosm.pitaya.security.Digest;
import org.kocakosm.pitaya.security.Factory;
import org.kocakosm.pitaya.security.KDF;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.XObjects;

final class PBKDF1
implements KDF {
    private final int dkLen;
    private final int iterationCount;
    private final Algorithm<Digest> algorithm;

    PBKDF1(Algorithm<Digest> algorithm, int iterationCount, int dkLen) {
        Parameters.checkCondition(dkLen > 0);
        Parameters.checkCondition(iterationCount > 0);
        Digest digest = Factory.newDigest(algorithm);
        Parameters.checkCondition(dkLen <= digest.length());
        this.algorithm = algorithm;
        this.iterationCount = iterationCount;
        this.dkLen = dkLen;
    }

    @Override
    public byte[] deriveKey(byte[] secret, byte[] salt) {
        Digest digest = Factory.newDigest(this.algorithm);
        byte[] hash = digest.update(secret).digest(salt);
        for (int i = 1; i < this.iterationCount; ++i) {
            hash = digest.digest(hash);
        }
        return Arrays.copyOf(hash, this.dkLen);
    }

    public String toString() {
        return XObjects.toStringBuilder("PBKDF1").append("digest", this.algorithm).append("iterationCount", this.iterationCount).append("dkLen", this.dkLen).toString();
    }
}

