/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.time;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.kocakosm.pitaya.util.Parameters;

public final class Dates {
    public static Date copy(Date date) {
        return date == null ? null : new Date(date.getTime());
    }

    public static Date now() {
        return new Date();
    }

    public static boolean isSameInstant(Date date1, Date date2) {
        return date1.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(Calendar cal1, Calendar cal2) {
        return Dates.isSameInstant(cal1.getTime(), cal2.getTime());
    }

    public static boolean isSameLocalTime(Date date1, Date date2) {
        return Dates.isSameLocalTime(Dates.toCalendar(date1), Dates.toCalendar(date2));
    }

    public static boolean isSameLocalTime(Calendar cal1, Calendar cal2) {
        return cal1.get(14) == cal2.get(14) && cal1.get(13) == cal2.get(13) && cal1.get(12) == cal2.get(12) && cal1.get(11) == cal2.get(11) && cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        return Dates.isSameDay(Dates.toCalendar(date1), Dates.toCalendar(date2));
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameWeek(Date date1, Date date2) {
        return Dates.isSameWeek(Dates.toCalendar(date1), Dates.toCalendar(date2));
    }

    public static boolean isSameWeek(Calendar cal1, Calendar cal2) {
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(3) == cal2.get(3);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        return Dates.isSameMonth(Dates.toCalendar(date1), Dates.toCalendar(date2));
    }

    public static boolean isSameMonth(Calendar cal1, Calendar cal2) {
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static boolean isSameYear(Date date1, Date date2) {
        return Dates.isSameYear(Dates.toCalendar(date1), Dates.toCalendar(date2));
    }

    public static boolean isSameYear(Calendar cal1, Calendar cal2) {
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1);
    }

    public static Date parse(String date, String ... formats) {
        return Dates.parse(date, Locale.getDefault(), formats);
    }

    public static Date parse(String date, Locale locale, String ... formats) {
        Parameters.checkNotNull(date);
        Parameters.checkCondition(formats.length > 0);
        for (String format : formats) {
            SimpleDateFormat df = new SimpleDateFormat(format, locale);
            df.setLenient(true);
            ParsePosition position = new ParsePosition(0);
            Date d = ((DateFormat)df).parse(date, position);
            if (d == null || position.getIndex() != date.length()) continue;
            return d;
        }
        throw new IllegalArgumentException("Unparseable date: " + date);
    }

    public static String format(Date date, String format) {
        Parameters.checkNotNull(date);
        return new SimpleDateFormat(format).format(date);
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    private Dates() {
    }
}

