/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import org.kocakosm.pitaya.charset.ASCII;
import org.kocakosm.pitaya.util.Parameters;

final class Alphabet {
    static final Alphabet BASE_64 = new Alphabet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", true);
    static final Alphabet BASE_64_URL = new Alphabet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_", true);
    static final Alphabet BASE_32 = new Alphabet("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", false);
    static final Alphabet BASE_32_HEX = new Alphabet("0123456789ABCDEFGHIJKLMNOPQRSTUV", false);
    static final Alphabet BASE_16 = new Alphabet("0123456789ABCDEF", false);
    private final char[] alphabet;
    private final boolean caseSensitive;
    private final int bitsPerChar;
    private final int charsPerBlock;
    private final int bytesPerBlock;
    private final int maxPaddingLength;

    private Alphabet(String alphabet, boolean caseSensitive) {
        Parameters.checkCondition(ASCII.canEncode(alphabet));
        this.alphabet = caseSensitive ? alphabet.toCharArray() : ASCII.toUpperCase(alphabet).toCharArray();
        this.caseSensitive = caseSensitive;
        this.bitsPerChar = this.round(Math.log(alphabet.length()) / Math.log(2.0));
        int gcd = this.gcd(8, this.bitsPerChar);
        this.charsPerBlock = 8 / gcd;
        this.bytesPerBlock = this.bitsPerChar / gcd;
        this.maxPaddingLength = this.charsPerBlock - this.floor(8.0 / (double)this.bitsPerChar);
    }

    private int round(double x) {
        return (int)Math.round(x);
    }

    private int floor(double x) {
        return (int)Math.floor(x);
    }

    private int gcd(int a, int b) {
        return b == 0 ? a : this.gcd(b, a % b);
    }

    int decode(char c) {
        char encoded = this.caseSensitive ? c : ASCII.toUpperCase(c);
        for (int i = 0; i < this.alphabet.length; ++i) {
            if (encoded != this.alphabet[i]) continue;
            return i;
        }
        return -1;
    }

    char encode(int value) {
        return this.alphabet[value & this.alphabet.length - 1];
    }

    int bitsPerChar() {
        return this.bitsPerChar;
    }

    int charsPerBlock() {
        return this.charsPerBlock;
    }

    int bytesPerBlock() {
        return this.bytesPerBlock;
    }

    int maxPaddingLength() {
        return this.maxPaddingLength;
    }

    boolean requiresPadding() {
        return this.maxPaddingLength > 0;
    }
}

