/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import org.kocakosm.pitaya.util.Parameters;

public final class Booleans {
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;

    public static Boolean and(Boolean ... bools) {
        Parameters.checkCondition(bools.length > 0);
        for (Boolean bool : bools) {
            if (bool.booleanValue()) continue;
            return FALSE;
        }
        return TRUE;
    }

    public static Boolean or(Boolean ... bools) {
        Parameters.checkCondition(bools.length > 0);
        for (Boolean bool : bools) {
            if (!bool.booleanValue()) continue;
            return TRUE;
        }
        return FALSE;
    }

    public static Boolean not(Boolean bool) {
        return bool != false ? FALSE : TRUE;
    }

    public static Boolean xor(Boolean ... bools) {
        Parameters.checkCondition(bools.length > 0);
        boolean xor = false;
        for (Boolean bool : bools) {
            if (!bool.booleanValue()) continue;
            if (xor) {
                return FALSE;
            }
            xor = true;
        }
        return xor ? TRUE : FALSE;
    }

    public static boolean isFalse(Boolean bool) {
        return bool == null ? false : bool == false;
    }

    public static boolean isNotFalse(Boolean bool) {
        return bool == null ? true : bool;
    }

    public static boolean isTrue(Boolean bool) {
        return bool == null ? false : bool;
    }

    public static boolean isNotTrue(Boolean bool) {
        return bool == null ? true : bool == false;
    }

    public static Boolean valueOf(String bool) {
        String s = bool.replaceAll("\\s", "");
        boolean b = "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s) || "1".equalsIgnoreCase(s);
        return b ? TRUE : FALSE;
    }

    public static Boolean valueOf(int i) {
        return i == 0 ? FALSE : TRUE;
    }

    public static Boolean valueOf(Integer i) {
        return Booleans.valueOf((int)i);
    }

    public static Boolean valueOf(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static Integer toInteger(boolean bool) {
        return bool ? 1 : 0;
    }

    public static Integer toInteger(Boolean bool) {
        return Booleans.toInteger((boolean)bool);
    }

    public static String toString(boolean bool) {
        return bool ? "true" : "false";
    }

    private Booleans() {
    }
}

