/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.kocakosm.pitaya.util.BaseEncoding;
import org.kocakosm.pitaya.util.Parameters;

public final class ByteBuffer
implements Iterable<Byte>,
Serializable {
    private static final long serialVersionUID = 5183155512871175888L;
    private static final int DEFAULT_CAPACITY = 512;
    private byte[] buf;
    private int count;
    private int capacity;

    public ByteBuffer() {
        this(512);
    }

    public ByteBuffer(int capacity) {
        Parameters.checkCondition(capacity >= 0);
        this.buf = new byte[capacity];
        this.capacity = capacity;
    }

    public ByteBuffer(byte ... bytes) {
        this.count = bytes.length;
        this.capacity = Math.max(this.count * 3 / 2 + 1, 512);
        this.buf = new byte[this.capacity];
        System.arraycopy(bytes, 0, this.buf, 0, this.count);
    }

    public ByteBuffer append(byte b) {
        int newCount = this.count + 1;
        this.ensureCapacity(newCount);
        this.buf[this.count] = b;
        this.count = newCount;
        return this;
    }

    public ByteBuffer append(byte ... bytes) {
        this.append(bytes, 0, bytes.length);
        return this;
    }

    public ByteBuffer append(byte[] bytes, int off, int len) {
        int newCount = this.count + len;
        this.ensureCapacity(newCount);
        System.arraycopy(bytes, off, this.buf, this.count, len);
        this.count = newCount;
        return this;
    }

    public ByteBuffer clear() {
        this.count = 0;
        this.buf = new byte[this.capacity];
        return this;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.count];
        System.arraycopy(this.buf, 0, data, 0, this.count);
        return data;
    }

    public byte[] toByteArray(int off) {
        return this.toByteArray(off, this.count - off);
    }

    public byte[] toByteArray(int off, int len) {
        if (off < 0 || len < 0 || off + len > this.count) {
            throw new IndexOutOfBoundsException();
        }
        byte[] data = new byte[len];
        System.arraycopy(this.buf, off, data, 0, len);
        return data;
    }

    @Override
    public Iterator<Byte> iterator() {
        return new ByteBufferIterator();
    }

    public String toString() {
        return BaseEncoding.BASE_16.encode(this.buf, 0, this.count);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer buffer = (ByteBuffer)o;
        if (this.count != buffer.count) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.buf[i] == buffer.buf[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        if (this.count == 0) {
            return hash;
        }
        hash = 17 * hash + this.count;
        hash = 17 * hash + this.buf[0];
        hash = 17 * hash + this.buf[this.count];
        return hash;
    }

    private void ensureCapacity(int capacity) {
        int oldSize = this.buf.length;
        if (capacity > oldSize) {
            int newSize = Math.max(oldSize * 3 / 2 + 1, capacity);
            byte[] newBuf = new byte[newSize];
            System.arraycopy(this.buf, 0, newBuf, 0, this.count);
            this.buf = newBuf;
        }
    }

    private final class ByteBufferIterator
    implements Iterator<Byte> {
        private int index;

        private ByteBufferIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ByteBuffer.this.count;
        }

        @Override
        public Byte next() {
            if (this.index >= ByteBuffer.this.count) {
                throw new NoSuchElementException();
            }
            return ByteBuffer.this.buf[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

