/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.util.Arrays;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.XObjects;

public final class Joiner {
    private final String separator;
    private final String prefix;
    private final String suffix;
    private final boolean trim;
    private final boolean ignoreNull;
    private final boolean ignoreEmpty;
    private final String forNull;
    private final String forEmpty;

    public static Joiner on(String separator) {
        return new Joiner(separator, "", "", false, false, false, "null", "");
    }

    private Joiner(String separator, String prefix, String suffix, boolean trim, boolean ignoreNull, boolean ignoreEmpty, String forNull, String forEmpty) {
        Parameters.checkNotNull(separator);
        Parameters.checkNotNull(prefix);
        Parameters.checkNotNull(suffix);
        Parameters.checkNotNull(forNull);
        Parameters.checkNotNull(forEmpty);
        this.separator = separator;
        this.prefix = prefix;
        this.suffix = suffix;
        this.trim = trim;
        this.ignoreNull = ignoreNull;
        this.ignoreEmpty = ignoreEmpty;
        this.forNull = forNull;
        this.forEmpty = forEmpty;
    }

    public Joiner trimInputs() {
        return new Joiner(this.separator, this.prefix, this.suffix, true, this.ignoreNull, this.ignoreEmpty, this.forNull, this.forEmpty);
    }

    public Joiner ignoreNulls() {
        return new Joiner(this.separator, this.prefix, this.suffix, this.trim, true, this.ignoreEmpty, this.forNull, this.forEmpty);
    }

    public Joiner ignoreEmptyStrings() {
        return new Joiner(this.separator, this.prefix, this.suffix, this.trim, this.ignoreNull, true, this.forNull, this.forEmpty);
    }

    public Joiner replaceNullWith(String forNull) {
        return new Joiner(this.separator, this.prefix, this.suffix, this.trim, false, this.ignoreEmpty, forNull, this.forEmpty);
    }

    public Joiner replaceEmptyStringWith(String forEmpty) {
        return new Joiner(this.separator, this.prefix, this.suffix, this.trim, this.ignoreNull, false, this.forNull, forEmpty);
    }

    public Joiner withPrefix(String prefix) {
        return new Joiner(this.separator, prefix, this.suffix, this.trim, this.ignoreNull, this.ignoreEmpty, this.forNull, this.forEmpty);
    }

    public Joiner withSuffix(String suffix) {
        return new Joiner(this.separator, this.prefix, suffix, this.trim, this.ignoreNull, this.ignoreEmpty, this.forNull, this.forEmpty);
    }

    public String join(Object ... parts) {
        return this.join(Arrays.asList(parts));
    }

    public String join(Iterable<?> parts) {
        boolean first = true;
        StringBuilder sb = new StringBuilder(this.prefix);
        for (Object part : parts) {
            String s = this.format(part);
            if (s == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(this.separator);
            }
            sb.append(s);
        }
        return sb.append(this.suffix).toString();
    }

    private String format(Object o) {
        if (this.ignoreNull && o == null) {
            return null;
        }
        String s = XObjects.toString(o, this.forNull);
        String string = s = this.trim ? s.trim() : s;
        if (s.isEmpty()) {
            return this.ignoreEmpty ? null : this.forEmpty;
        }
        return s;
    }
}

