/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.kocakosm.pitaya.util.Parameters;

public final class Splitter {
    private final int limit;
    private final boolean trim;
    private final Pattern pattern;
    private final String prefix;
    private final String suffix;
    private final String forEmpty;
    private final boolean ignoreEmptyStrings;

    public static Splitter on(String separator) {
        StringBuilder sb = new StringBuilder(separator.length() * 2);
        for (char c : separator.toCharArray()) {
            sb.append('\\').append(c);
        }
        return Splitter.on(Pattern.compile(sb.toString()));
    }

    public static Splitter on(Pattern pattern) {
        return new Splitter(-1, false, pattern, null, null, "", false);
    }

    private Splitter(int limit, boolean trim, Pattern pattern, String prefix, String suffix, String forEmpty, boolean ignoreEmptyStrings) {
        Parameters.checkNotNull(pattern);
        Parameters.checkNotNull(forEmpty);
        this.limit = limit;
        this.trim = trim;
        this.pattern = pattern;
        this.suffix = suffix;
        this.prefix = prefix;
        this.forEmpty = forEmpty;
        this.ignoreEmptyStrings = ignoreEmptyStrings;
    }

    public Splitter limit(int limit) {
        return new Splitter(limit == 0 ? -1 : limit, this.trim, this.pattern, this.prefix, this.suffix, this.forEmpty, this.ignoreEmptyStrings);
    }

    public Splitter trimResults() {
        return new Splitter(this.limit, true, this.pattern, this.prefix, this.suffix, this.forEmpty, this.ignoreEmptyStrings);
    }

    public Splitter ignorePrefix(String prefix) {
        Parameters.checkNotNull(prefix);
        return new Splitter(this.limit, this.trim, this.pattern, prefix, this.suffix, this.forEmpty, this.ignoreEmptyStrings);
    }

    public Splitter ignoreSuffix(String suffix) {
        Parameters.checkNotNull(suffix);
        return new Splitter(this.limit, this.trim, this.pattern, this.prefix, suffix, this.forEmpty, this.ignoreEmptyStrings);
    }

    public Splitter ignoreEmptyStrings() {
        return new Splitter(this.limit, this.trim, this.pattern, this.prefix, this.suffix, this.forEmpty, true);
    }

    public Splitter replaceEmptyStringWith(String forEmpty) {
        return new Splitter(this.limit, this.trim, this.pattern, this.prefix, this.suffix, forEmpty, this.ignoreEmptyStrings);
    }

    public List<String> split(String s) {
        String[] parts = this.pattern.split(this.formatInput(s), this.limit);
        ArrayList<String> results = new ArrayList<String>(parts.length);
        for (String part : parts) {
            String str = this.formatOutput(part);
            if (str == null) continue;
            results.add(str);
        }
        return Collections.unmodifiableList(results);
    }

    private String formatInput(String input) {
        String s = this.prefix != null && input.startsWith(this.prefix) ? input.substring(this.prefix.length()) : input;
        return this.suffix != null && s.endsWith(this.suffix) ? s.substring(0, s.length() - this.suffix.length()) : s;
    }

    private String formatOutput(String part) {
        String s;
        String string = s = this.trim ? part.trim() : part;
        if (s.isEmpty()) {
            return this.ignoreEmptyStrings ? null : this.forEmpty;
        }
        return s;
    }
}

