/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kocakosm.pitaya.util.Parameters;

public final class Throwables {
    public static Throwable getRootCause(Throwable t) {
        Throwable cause = t.getCause();
        return cause == null ? t : Throwables.getRootCause(cause);
    }

    public static List<Throwable> getCauseChain(Throwable t) {
        ArrayList<Throwable> chain = new ArrayList<Throwable>();
        chain.add(Parameters.checkNotNull(t));
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            chain.add(cause);
        }
        return Collections.unmodifiableList(chain);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        t.printStackTrace(writer);
        writer.flush();
        return out.toString();
    }

    public static List<String> getStackFrames(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        ArrayList<String> frames = new ArrayList<String>(elements.length);
        for (StackTraceElement element : elements) {
            frames.add(element.toString());
        }
        return Collections.unmodifiableList(frames);
    }

    public static RuntimeException propagate(Throwable t) {
        Parameters.checkNotNull(t);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    private Throwables() {
    }
}

