/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.kocakosm.pitaya.util.Parameters;

public final class XArrays {
    private static final Random PRNG = new Random();

    public static boolean isNullOrEmpty(long[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(int[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(short[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(char[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(byte[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(boolean[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(float[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(double[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(Object[] a) {
        return a == null || a.length == 0;
    }

    public static long[] concat(long[] ... arrays) {
        int len = 0;
        for (long[] array : arrays) {
            len += array.length;
        }
        long[] concat = new long[len];
        int i = 0;
        for (long[] array : arrays) {
            System.arraycopy(array, 0, concat, i, array.length);
            i = array.length;
        }
        return concat;
    }

    public static int[] concat(int[] ... arrays) {
        int len = 0;
        for (int[] array : arrays) {
            len += array.length;
        }
        int[] concat = new int[len];
        int i = 0;
        for (int[] array : arrays) {
            System.arraycopy(array, 0, concat, i, array.length);
            i = array.length;
        }
        return concat;
    }

    public static short[] concat(short[] ... arrays) {
        int len = 0;
        for (short[] array : arrays) {
            len += array.length;
        }
        short[] concat = new short[len];
        int i = 0;
        for (short[] array : arrays) {
            System.arraycopy(array, 0, concat, i, array.length);
            i = array.length;
        }
        return concat;
    }

    public static char[] concat(char[] ... arrays) {
        int len = 0;
        for (char[] array : arrays) {
            len += array.length;
        }
        char[] concat = new char[len];
        int i = 0;
        for (char[] array : arrays) {
            System.arraycopy(array, 0, concat, i, array.length);
            i = array.length;
        }
        return concat;
    }

    public static byte[] concat(byte[] ... arrays) {
        int len = 0;
        for (byte[] array : arrays) {
            len += array.length;
        }
        byte[] concat = new byte[len];
        int i = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, concat, i, array.length);
            i = array.length;
        }
        return concat;
    }

    public static boolean[] concat(boolean[] ... arrays) {
        int len = 0;
        for (boolean[] array : arrays) {
            len += array.length;
        }
        boolean[] concat = new boolean[len];
        int i = 0;
        for (boolean[] array : arrays) {
            System.arraycopy(array, 0, concat, i, array.length);
            i = array.length;
        }
        return concat;
    }

    public static float[] concat(float[] ... arrays) {
        int len = 0;
        for (float[] array : arrays) {
            len += array.length;
        }
        float[] concat = new float[len];
        int i = 0;
        for (float[] array : arrays) {
            System.arraycopy(array, 0, concat, i, array.length);
            i = array.length;
        }
        return concat;
    }

    public static double[] concat(double[] ... arrays) {
        int len = 0;
        for (double[] array : arrays) {
            len += array.length;
        }
        double[] concat = new double[len];
        int i = 0;
        for (double[] array : arrays) {
            System.arraycopy(array, 0, concat, i, array.length);
            i = array.length;
        }
        return concat;
    }

    public static <T> T[] concat(T[] ... arrays) {
        Parameters.checkCondition(arrays.length > 0);
        int len = 0;
        for (T[] array : arrays) {
            len += array.length;
        }
        T[] concat = XArrays.newArray(arrays[0].getClass().getComponentType(), len);
        int i = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, concat, i, array.length);
            i = array.length;
        }
        return concat;
    }

    public static long[] copyOf(long[] a, int off, int len) {
        long[] copy = new long[len];
        if (len > a.length - off) {
            System.arraycopy(a, off, copy, 0, a.length - off);
        } else {
            System.arraycopy(a, off, copy, 0, len);
        }
        return copy;
    }

    public static int[] copyOf(int[] a, int off, int len) {
        int[] copy = new int[len];
        if (len > a.length - off) {
            System.arraycopy(a, off, copy, 0, a.length - off);
        } else {
            System.arraycopy(a, off, copy, 0, len);
        }
        return copy;
    }

    public static short[] copyOf(short[] a, int off, int len) {
        short[] copy = new short[len];
        if (len > a.length - off) {
            System.arraycopy(a, off, copy, 0, a.length - off);
        } else {
            System.arraycopy(a, off, copy, 0, len);
        }
        return copy;
    }

    public static char[] copyOf(char[] a, int off, int len) {
        char[] copy = new char[len];
        if (len > a.length - off) {
            System.arraycopy(a, off, copy, 0, a.length - off);
        } else {
            System.arraycopy(a, off, copy, 0, len);
        }
        return copy;
    }

    public static byte[] copyOf(byte[] a, int off, int len) {
        byte[] copy = new byte[len];
        if (len > a.length - off) {
            System.arraycopy(a, off, copy, 0, a.length - off);
        } else {
            System.arraycopy(a, off, copy, 0, len);
        }
        return copy;
    }

    public static boolean[] copyOf(boolean[] a, int off, int len) {
        boolean[] copy = new boolean[len];
        if (len > a.length - off) {
            System.arraycopy(a, off, copy, 0, a.length - off);
        } else {
            System.arraycopy(a, off, copy, 0, len);
        }
        return copy;
    }

    public static float[] copyOf(float[] a, int off, int len) {
        float[] copy = new float[len];
        if (len > a.length - off) {
            System.arraycopy(a, off, copy, 0, a.length - off);
        } else {
            System.arraycopy(a, off, copy, 0, len);
        }
        return copy;
    }

    public static double[] copyOf(double[] a, int off, int len) {
        double[] copy = new double[len];
        if (len > a.length - off) {
            System.arraycopy(a, off, copy, 0, a.length - off);
        } else {
            System.arraycopy(a, off, copy, 0, len);
        }
        return copy;
    }

    public static <T> T[] copyOf(T[] a, int off, int len) {
        T[] copy = XArrays.newArray(a.getClass().getComponentType(), len);
        if (len > a.length - off) {
            System.arraycopy(a, off, copy, 0, a.length - off);
        } else {
            System.arraycopy(a, off, copy, 0, len);
        }
        return copy;
    }

    public static long[] copyOf(long ... original) {
        return Arrays.copyOf(original, original.length);
    }

    public static int[] copyOf(int ... original) {
        return Arrays.copyOf(original, original.length);
    }

    public static short[] copyOf(short ... original) {
        return Arrays.copyOf(original, original.length);
    }

    public static char[] copyOf(char ... original) {
        return Arrays.copyOf(original, original.length);
    }

    public static byte[] copyOf(byte ... original) {
        return Arrays.copyOf(original, original.length);
    }

    public static boolean[] copyOf(boolean ... original) {
        return Arrays.copyOf(original, original.length);
    }

    public static float[] copyOf(float ... original) {
        return Arrays.copyOf(original, original.length);
    }

    public static double[] copyOf(double ... original) {
        return Arrays.copyOf(original, original.length);
    }

    public static <T> T[] copyOf(T[] original) {
        return Arrays.copyOf(original, original.length);
    }

    public static long[] reverse(long ... a) {
        int len = a.length;
        long[] copy = new long[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[len - i - 1];
        }
        return copy;
    }

    public static int[] reverse(int ... a) {
        int len = a.length;
        int[] copy = new int[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[len - i - 1];
        }
        return copy;
    }

    public static short[] reverse(short ... a) {
        int len = a.length;
        short[] copy = new short[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[len - i - 1];
        }
        return copy;
    }

    public static char[] reverse(char ... a) {
        int len = a.length;
        char[] copy = new char[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[len - i - 1];
        }
        return copy;
    }

    public static byte[] reverse(byte ... a) {
        int len = a.length;
        byte[] copy = new byte[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[len - i - 1];
        }
        return copy;
    }

    public static boolean[] reverse(boolean ... a) {
        int len = a.length;
        boolean[] copy = new boolean[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[len - i - 1];
        }
        return copy;
    }

    public static float[] reverse(float ... a) {
        int len = a.length;
        float[] copy = new float[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[len - i - 1];
        }
        return copy;
    }

    public static double[] reverse(double ... a) {
        int len = a.length;
        double[] copy = new double[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[len - i - 1];
        }
        return copy;
    }

    public static <T> T[] reverse(T[] a) {
        int len = a.length;
        T[] copy = XArrays.newArray(a.getClass().getComponentType(), len);
        for (int i = 0; i < len; ++i) {
            copy[i] = a[len - i - 1];
        }
        return copy;
    }

    public static long[] rotate(long[] a, int distance) {
        int len = a.length;
        long[] copy = new long[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[XArrays.index(i - distance, len)];
        }
        return copy;
    }

    public static int[] rotate(int[] a, int distance) {
        int len = a.length;
        int[] copy = new int[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[XArrays.index(i - distance, len)];
        }
        return copy;
    }

    public static short[] rotate(short[] a, int distance) {
        int len = a.length;
        short[] copy = new short[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[XArrays.index(i - distance, len)];
        }
        return copy;
    }

    public static char[] rotate(char[] a, int distance) {
        int len = a.length;
        char[] copy = new char[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[XArrays.index(i - distance, len)];
        }
        return copy;
    }

    public static byte[] rotate(byte[] a, int distance) {
        int len = a.length;
        byte[] copy = new byte[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[XArrays.index(i - distance, len)];
        }
        return copy;
    }

    public static boolean[] rotate(boolean[] a, int distance) {
        int len = a.length;
        boolean[] copy = new boolean[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[XArrays.index(i - distance, len)];
        }
        return copy;
    }

    public static float[] rotate(float[] a, int distance) {
        int len = a.length;
        float[] copy = new float[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[XArrays.index(i - distance, len)];
        }
        return copy;
    }

    public static double[] rotate(double[] a, int distance) {
        int len = a.length;
        double[] copy = new double[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = a[XArrays.index(i - distance, len)];
        }
        return copy;
    }

    public static <T> T[] rotate(T[] a, int distance) {
        int len = a.length;
        T[] copy = XArrays.newArray(a.getClass().getComponentType(), len);
        for (int i = 0; i < len; ++i) {
            copy[i] = a[XArrays.index(i - distance, len)];
        }
        return copy;
    }

    private static int index(int x, int mod) {
        return x < 0 ? XArrays.index(x + mod, mod) : x % mod;
    }

    public static long[] shuffle(long ... a) {
        return XArrays.shuffle(a, PRNG);
    }

    public static long[] shuffle(long[] a, Random rnd) {
        long[] copy = XArrays.copyOf(a);
        for (int i = copy.length; i > 1; --i) {
            XArrays.swap(copy, i - 1, rnd.nextInt(i));
        }
        return copy;
    }

    private static void swap(long[] a, int i, int j) {
        long c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    public static int[] shuffle(int ... a) {
        return XArrays.shuffle(a, PRNG);
    }

    public static int[] shuffle(int[] a, Random rnd) {
        int[] copy = XArrays.copyOf(a);
        for (int i = copy.length; i > 1; --i) {
            XArrays.swap(copy, i - 1, rnd.nextInt(i));
        }
        return copy;
    }

    private static void swap(int[] a, int i, int j) {
        int c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    public static short[] shuffle(short ... a) {
        return XArrays.shuffle(a, PRNG);
    }

    public static short[] shuffle(short[] a, Random rnd) {
        short[] copy = XArrays.copyOf(a);
        for (int i = copy.length; i > 1; --i) {
            XArrays.swap(copy, i - 1, rnd.nextInt(i));
        }
        return copy;
    }

    private static void swap(short[] a, int i, int j) {
        short c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    public static char[] shuffle(char ... a) {
        return XArrays.shuffle(a, PRNG);
    }

    public static char[] shuffle(char[] a, Random rnd) {
        char[] copy = XArrays.copyOf(a);
        for (int i = copy.length; i > 1; --i) {
            XArrays.swap(copy, i - 1, rnd.nextInt(i));
        }
        return copy;
    }

    private static void swap(char[] a, int i, int j) {
        char c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    public static byte[] shuffle(byte ... a) {
        return XArrays.shuffle(a, PRNG);
    }

    public static byte[] shuffle(byte[] a, Random rnd) {
        byte[] copy = XArrays.copyOf(a);
        for (int i = copy.length; i > 1; --i) {
            XArrays.swap(copy, i - 1, rnd.nextInt(i));
        }
        return copy;
    }

    private static void swap(byte[] a, int i, int j) {
        byte c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    public static boolean[] shuffle(boolean ... a) {
        return XArrays.shuffle(a, PRNG);
    }

    public static boolean[] shuffle(boolean[] a, Random rnd) {
        boolean[] copy = XArrays.copyOf(a);
        for (int i = copy.length; i > 1; --i) {
            XArrays.swap(copy, i - 1, rnd.nextInt(i));
        }
        return copy;
    }

    private static void swap(boolean[] a, int i, int j) {
        boolean c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    public static float[] shuffle(float ... a) {
        return XArrays.shuffle(a, PRNG);
    }

    public static float[] shuffle(float[] a, Random rnd) {
        float[] copy = XArrays.copyOf(a);
        for (int i = copy.length; i > 1; --i) {
            XArrays.swap(copy, i - 1, rnd.nextInt(i));
        }
        return copy;
    }

    private static void swap(float[] a, int i, int j) {
        float c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    public static double[] shuffle(double ... a) {
        return XArrays.shuffle(a, PRNG);
    }

    public static double[] shuffle(double[] a, Random rnd) {
        double[] copy = XArrays.copyOf(a);
        for (int i = copy.length; i > 1; --i) {
            XArrays.swap(copy, i - 1, rnd.nextInt(i));
        }
        return copy;
    }

    private static void swap(double[] a, int i, int j) {
        double c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    public static <T> T[] shuffle(T[] a) {
        return XArrays.shuffle(a, PRNG);
    }

    public static <T> T[] shuffle(T[] a, Random rnd) {
        T[] copy = XArrays.copyOf(a);
        for (int i = copy.length; i > 1; --i) {
            XArrays.swap(copy, i - 1, rnd.nextInt(i));
        }
        return copy;
    }

    private static <T> void swap(T[] a, int i, int j) {
        T c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    public static long[] sort(long ... a) {
        long[] copy = XArrays.copyOf(a);
        Arrays.sort(copy);
        return copy;
    }

    public static int[] sort(int ... a) {
        int[] copy = XArrays.copyOf(a);
        Arrays.sort(copy);
        return copy;
    }

    public static short[] sort(short ... a) {
        short[] copy = XArrays.copyOf(a);
        Arrays.sort(copy);
        return copy;
    }

    public static char[] sort(char ... a) {
        char[] copy = XArrays.copyOf(a);
        Arrays.sort(copy);
        return copy;
    }

    public static byte[] sort(byte ... a) {
        byte[] copy = XArrays.copyOf(a);
        Arrays.sort(copy);
        return copy;
    }

    public static float[] sort(float ... a) {
        float[] copy = XArrays.copyOf(a);
        Arrays.sort(copy);
        return copy;
    }

    public static double[] sort(double ... a) {
        double[] copy = XArrays.copyOf(a);
        Arrays.sort(copy);
        return copy;
    }

    public static <T> T[] sort(T[] a) {
        Object[] copy = XArrays.copyOf(a);
        Arrays.sort(copy);
        return copy;
    }

    public static <T> T[] sort(T[] a, Comparator<? super T> c) {
        T[] copy = Arrays.copyOf(a, a.length);
        Arrays.sort(copy, c);
        return copy;
    }

    public static long[] toPrimitive(Long ... a) {
        if (a != null) {
            long[] p = new long[a.length];
            for (int i = 0; i < a.length; ++i) {
                p[i] = a[i];
            }
            return p;
        }
        return null;
    }

    public static int[] toPrimitive(Integer ... a) {
        if (a != null) {
            int[] p = new int[a.length];
            for (int i = 0; i < a.length; ++i) {
                p[i] = a[i];
            }
            return p;
        }
        return null;
    }

    public static short[] toPrimitive(Short ... a) {
        if (a != null) {
            short[] p = new short[a.length];
            for (int i = 0; i < a.length; ++i) {
                p[i] = a[i];
            }
            return p;
        }
        return null;
    }

    public static char[] toPrimitive(Character ... a) {
        if (a != null) {
            char[] p = new char[a.length];
            for (int i = 0; i < a.length; ++i) {
                p[i] = a[i].charValue();
            }
            return p;
        }
        return null;
    }

    public static byte[] toPrimitive(Byte ... a) {
        if (a != null) {
            byte[] p = new byte[a.length];
            for (int i = 0; i < a.length; ++i) {
                p[i] = a[i];
            }
            return p;
        }
        return null;
    }

    public static boolean[] toPrimitive(Boolean ... a) {
        if (a != null) {
            boolean[] p = new boolean[a.length];
            for (int i = 0; i < a.length; ++i) {
                p[i] = a[i];
            }
            return p;
        }
        return null;
    }

    public static float[] toPrimitive(Float ... a) {
        if (a != null) {
            float[] p = new float[a.length];
            for (int i = 0; i < a.length; ++i) {
                p[i] = a[i].floatValue();
            }
            return p;
        }
        return null;
    }

    public static double[] toPrimitive(Double ... a) {
        if (a != null) {
            double[] p = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                p[i] = a[i];
            }
            return p;
        }
        return null;
    }

    public static Long[] toObject(long ... a) {
        if (a != null) {
            Long[] w = new Long[a.length];
            for (int i = 0; i < a.length; ++i) {
                w[i] = a[i];
            }
            return w;
        }
        return null;
    }

    public static Integer[] toObject(int ... a) {
        if (a != null) {
            Integer[] w = new Integer[a.length];
            for (int i = 0; i < a.length; ++i) {
                w[i] = a[i];
            }
            return w;
        }
        return null;
    }

    public static Short[] toObject(short ... a) {
        if (a != null) {
            Short[] w = new Short[a.length];
            for (int i = 0; i < a.length; ++i) {
                w[i] = a[i];
            }
            return w;
        }
        return null;
    }

    public static Character[] toObject(char ... a) {
        if (a != null) {
            Character[] w = new Character[a.length];
            for (int i = 0; i < a.length; ++i) {
                w[i] = Character.valueOf(a[i]);
            }
            return w;
        }
        return null;
    }

    public static Byte[] toObject(byte ... a) {
        if (a != null) {
            Byte[] w = new Byte[a.length];
            for (int i = 0; i < a.length; ++i) {
                w[i] = a[i];
            }
            return w;
        }
        return null;
    }

    public static Boolean[] toObject(boolean ... a) {
        if (a != null) {
            Boolean[] w = new Boolean[a.length];
            for (int i = 0; i < a.length; ++i) {
                w[i] = a[i];
            }
            return w;
        }
        return null;
    }

    public static Float[] toObject(float ... a) {
        if (a != null) {
            Float[] w = new Float[a.length];
            for (int i = 0; i < a.length; ++i) {
                w[i] = Float.valueOf(a[i]);
            }
            return w;
        }
        return null;
    }

    public static Double[] toObject(double ... a) {
        if (a != null) {
            Double[] w = new Double[a.length];
            for (int i = 0; i < a.length; ++i) {
                w[i] = a[i];
            }
            return w;
        }
        return null;
    }

    public static String toString(long ... a) {
        return Arrays.toString(a);
    }

    public static String toString(int ... a) {
        return Arrays.toString(a);
    }

    public static String toString(short ... a) {
        return Arrays.toString(a);
    }

    public static String toString(char ... a) {
        return Arrays.toString(a);
    }

    public static String toString(byte ... a) {
        return Arrays.toString(a);
    }

    public static String toString(boolean ... a) {
        return Arrays.toString(a);
    }

    public static String toString(float ... a) {
        return Arrays.toString(a);
    }

    public static String toString(double ... a) {
        return Arrays.toString(a);
    }

    public static String toString(Object[] a) {
        return Arrays.toString(a);
    }

    private static <T> T[] newArray(Class<?> componentType, int len) {
        return (Object[])Array.newInstance(componentType, len);
    }

    private XArrays() {
    }
}

