/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kocakosm.pitaya.collection.AbstractBag;
import org.kocakosm.pitaya.collection.Iterables;
import org.kocakosm.pitaya.util.Parameters;

public final class HashBag<E>
extends AbstractBag<E>
implements Serializable {
    private static final long serialVersionUID = 3651678489121314654L;
    private final Map<E, List<E>> entries;

    public HashBag() {
        this(10);
    }

    public HashBag(int initialCapacity) {
        Parameters.checkCondition(initialCapacity >= 0);
        this.entries = new HashMap<E, List<E>>(initialCapacity);
    }

    public HashBag(Collection<? extends E> c) {
        this(c.size());
        this.addAll(c);
    }

    public HashBag(Iterable<? extends E> i) {
        this();
        for (E e : i) {
            this.add(e);
        }
    }

    public HashBag(Iterator<? extends E> i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public HashBag(E ... elements) {
        this(Arrays.asList(elements));
    }

    @Override
    public boolean add(E e) {
        List<E> entry = this.entries.get(e);
        if (entry == null) {
            entry = new ArrayList();
            this.entries.put(e, entry);
        }
        return entry.add(e);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean contains(Object o) {
        List<E> entry = this.entries.get(o);
        return entry == null ? false : !entry.isEmpty();
    }

    @Override
    public int count(E e) {
        List<E> entry = this.entries.get(e);
        return entry == null ? 0 : entry.size();
    }

    @Override
    public Iterator<E> iterator() {
        return Iterables.concat(this.entries.values()).iterator();
    }

    @Override
    public boolean remove(Object o) {
        List<E> entry = this.entries.get(o);
        return entry == null ? false : entry.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.entries.remove(o) != null;
        }
        return removed;
    }

    @Override
    public int size() {
        int size = 0;
        for (List<E> value : this.entries.values()) {
            size += value.size();
        }
        return size;
    }
}

